<?php
namespace controllers;

use lib\EntityController;
use lib\Exception;
use lib\security\Security;
use lib\GoPrevException;
use lib\Navigation;
use lib\DBConnexion;
use lib\Courriel;
use entities\Programme;
use entities\Reconnaissance;
use entities\Membre;

class MailController extends EntityController
{
	public static $SECURITY = array(
		'sendMailing' => array(2,3,4,5,8),
		'formMailing' => array(2,3,4,5,8), 
		);

	public function formMailingAction($params=null)
	{
		if ( !isset($_GET['idProgramme']) 
			&& !isset($_GET['idReco']) 
			&& !Security::isBureau() 
			&& !Security::isAnimateur() 
			&& !Security::isCA() 
			&& !Security::isChargeDeMission() 
			&& !Security::isCoordinateur() 
			&& !Security::isAdmin()) throw new Exception ( 'ERR-USER-NOTHABILIT' );
		$Model['titre_page']    = "Envois de courriels.";
		$Model['corps_page']    = 'views/courriel/mailing.php';
		$filtre = "datedepart >= STR_TO_DATE('".DBConnexion::SQLEncode(date('d/m/Y'))."','%d/%m/%Y')";
		$sort   = "datedepart ASC";
		if ( isset($_GET['idProgramme']) ) $Model['idProgramme'] = $_GET['idProgramme'];
		if ( isset($_GET['idReco']) ) $Model['idReco'] = $_GET['idReco'];
		$Model['lstEntities']   = Programme::selectList($filtre,$sort);
		$Model['lstAdherents']  = Membre::selectList('id NOT IN (SELECT id_membre FROM gari_role_membre WHERE id_role = 7) AND id_etat != 7','nom,prenom');
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}
	
	public function sendMailingAction($params=null)
	{
		$typeMailing = $_POST['typeMailing'];
		$filtre = "id_etat NOT IN (7)";
		$lst     = null;
		$objet   = $_POST['objet'];
		$message = $_POST['message'];
		switch ( $typeMailing ) {
			case 'all' :
				$filtre .= " AND id IN (SELECT id_membre FROM gari_role_membre WHERE id_role = 1)";
				$lst = Membre::selectList($filtre);
				$message = '<H2>Message aux adhérents</H2><h4>Bonjour,</h4>'.$message;
				break;
			case 'CA' :
				$filtre .= " AND id IN (SELECT id_membre FROM gari_role_membre WHERE id_role = 4)";
				$lst = Membre::selectList($filtre);
				$message = '<H2>Message aux membres du CA</H2><h4>Bonjour,</h4>'.$message;
				break;
			case 'animateurs' :
				$filtre .= " AND id IN (SELECT id_membre FROM gari_role_membre WHERE id_role = 2)";
				$lst = Membre::selectList($filtre);
				$message = '<H2>Message aux animateurs</H2><h4>Bonjour,</h4>'.$message;
				break;
			case 'adherents' :
				$lst = array();
				foreach( $_POST['adherents'] as $idMembre ) {
					$lst[] = new Membre( intval($idMembre) );
				}
				$message = '<h4>Bonjour,</h4>'.$message;
				break;
			case 'partsRando' :
				if ( empty($_POST['id_programme']) ) throw new Exception ( 'ERR-PARAM-NOPARAM', array('NOM' => 'id_programme') );
				$programme = new Programme( intval($_POST['id_programme']) );
				$lst = array();
				foreach( $programme->animateurs as $animateur ) {
					$lst[] = $animateur->id_animateur;
				}
				foreach( $programme->participants as $participant ) {
					if ( $participant->id_membre != null ) $lst[] = $participant->id_membre;
					if ( $participant->id_personne != null ) $lst[] = $participant->id_personne;
				}
				$message = '<H2>Message aux participants de la randonnée du '.$programme->getAttribut('datedepart')->dateStr.'</H2><h4>Bonjour,</h4>'.$message;
				break;
			case 'partsReco' :
				if ( empty($_POST['id_reco']) ) throw new Exception ( 'ERR-PARAM-NOPARAM', array('NOM' => 'id_reco') );
				$reco = new Reconnaissance( intval($_POST['id_reco']) );
				$lst = array();
				foreach( $reco->participants as $participant ) {
					$lst[] = $participant->id_participant;
				}
				$message = '<H2>Message aux participants de la reconnaissance du '.$reco->getAttribut('datereco')->dateStr.'</H2><h4>Bonjour,</h4>'.$message;
				break;
		}
		$fichiers = ( !empty($_FILES) ) ? $_FILES : null;
		if ( Courriel::mailingList($lst,$objet,$message,$fichiers) ) throw new GoPrevException('MSG-SENDMAILING');
		else throw new Exception('ERR-SENDMAILING');
		return null;
	}

	public function addfileAction($params=null)
	{
		$Model['pos'] = ( isset($_GET['pos']) )  ? intval($_GET['pos'])  : 1;
		return array('views/courriel/pieceJointe.php',$Model,true);
	}
	
}