<?php
namespace controllers;

use lib\EntityController;
use lib\DBConnexion;
use lib\Exception;
use lib\GoPrevException;
use entities\Programme;
use entities\Participant;
use entities\Participant_Parcour;
use entities\Membre;
use entities\Personne;

class ParticipantController extends EntityController
{
	public static $SECURITY = array(
		'delete'  => array(0,5),
		'attente' => array(0,5),
		'paye'    => array(5),
		);
		
	protected static $ENTITY            = "entities\Participant";
	protected static $PATH_VIEW_ERROR   = 'views/error.php';

	public function deleteAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception ( 'ERR-PARAM-NOID' );
		$participant = $params['entity'];
		$participant->delete();
		throw new Exception('MSG-QUERYDELETE');
	}

	public function attenteAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception ( 'ERR-PARAM-NOID' );
		$participant = $params['entity'];
		if ( $participant->attente == 1 && $participant->programme->inscrits >= $participant->programme->nbplaces ) throw new Exception('ERR-MAX-PARTICIPANTS');
		if ( $participant->attente == 1 ) $participant->attente = 0;
		else $participant->attente = 1;
		$participant->update();
		throw new Exception();
	}

	public function payeAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception ( 'ERR-PARAM-NOID' );
		$participant = $params['entity'];
		if ( $participant->paye == 0 ) $participant->paye = 1;
		$participant->update();
		throw new Exception();
	}
	
}
