<?php
namespace controllers;

use lib\EntityController;
use lib\DBConnexion;
use lib\Navigation;
use lib\Exception;
use lib\GoPrevException;
use lib\security\Security;

use entities\Participant;
use entities\Programme;
use entities\Personne;
use entities\Membre;
use entities\Cheque;
use entities\Adresse;

class PersonneController extends EntityController
{
	public static $SECURITY = array(
		'list'           => array(2,3,4,5,6,8),
		'display'        => array(2,3,4,5,6,8), 
		'insert'         => array(5,6), 
		'update'         => array(5,6),
		'delete'         => array(5,6),
		'convert'        => array(5,6),
		'inc'            => array(5,6),
		);
	
	protected static $ENTITY            = "entities\Personne";
	protected static $PATH_VIEW_LIST    = 'views/personne/list.php';
	protected static $PATH_VIEW_CONVERT = 'views/membre/insert.php';
	protected static $PATH_VIEW_INSERT  = 'views/personne/insert.php';
	protected static $PATH_VIEW_UPDATE  = 'views/personne/insert.php';
	protected static $PATH_VIEW_DISPLAY = 'views/personne/display.php';

	public function listAction($params=null)
	{
		$Model['titre_page']    = "Liste des adhérents a l'essai";
		$ordre = "nom,prenom,datenaissance";
		$filtre = "";
		if ( isset($_POST['validForm']) ) {
			if ( !empty($_POST['recherche']) ) $Model['recherche'] = $_POST['recherche'];
			Navigation::putFiltre($Model); 
			if ( !empty($filtre) ) $filtre .= " AND ";
			$filtre .= $this->createFiltre( $Model );
		}
		elseif ( $filtres = Navigation::callFiltre() ) {
			$Model = $filtres;
			Navigation::putFiltre($Model); 
			if ( !empty($filtre) ) $filtre .= " AND ";
			$filtre .= $this->createFiltre( $Model );
		}
		$Model['corps_page']    = static::$PATH_VIEW_LIST;
		$Model['onglet'] = 'personnes';
		$Model['lstEntities']   = Personne::selectList($filtre,$ordre);
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	private function createFiltre( $Model ) 
	{
		$filtre = "";
		if ( !empty($Model['recherche']) ) {
			if ( !empty($filtre) ) $filtre .= " AND ";
			$filtre .= "( nom LIKE '%".$Model['recherche']."%' OR prenom LIKE '%".$Model['recherche']."%' OR note LIKE '%".$Model['recherche']."%' )";
		}
		return $filtre;
	}

	public function insertAction($params=null)
	{
		if ( isset($_POST['validForm']) ) {
			// Validation d'un Formulaire
			$personne = new Personne($_POST);
			if ( empty($_POST['id_programme']) ) {
				$personne->insert(true);
				throw new GoPrevException('MSG-QUERYINSERT');
			}
			else {
				$participant = new Participant();
				$personne->nbessais = 1;
				$participant->id_personne = $personne;
				$participant->id_programme = new Programme(intval($_POST['id_programme']));
				if ( $participant->id_programme->inscrits >= $participant->id_programme->nbplaces ) {
					$participant->attente = 1;
				}
				$participant->insert(true);
				throw new Exception('MSG-QUERYINSERT');
			}
		}
		$Model['entity']        = new Personne();
		$Model['titre_page']    = "Créer une nouvelle personne";
		$Model['corps_page']    = static::$PATH_VIEW_INSERT;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function deleteAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$personne = $params['entity'];
		if ( isset($_POST['validForm']) ) {
			// Validation d'un Formulaire
			$participants = Participant::selectList('id_personne='.$personne->id);
			foreach ( $participants as $participant ) {
				$participant->delete(true);
			}
			$personne->delete(true);
			throw new GoPrevException('MSG-QUERYDELETE');
		}
		// Affichage du formulaire
		$Model['titre_page']    = "Suppression d'une personne à l'essai.";
		$Model['corps_page']    = static::$PATH_VIEW_DELETE;
		$Model['entity']        = $personne;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function convertAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$personne = $params['entity'];
		$membre = new Membre();
		$membre->sexe = $personne->sexe;
		$membre->nom = $personne->nom;
		$membre->prenom = $personne->prenom;
		$membre->datenaissance = $personne->datenaissance;
		$membre->mail = $personne->mail;
		$membre->telephone = $personne->telephone;
		$membre->id_etat = 1;
		$membre->id_createur = Security::getConnectedUser()->id;
		if ( $personne->codepostal != null ) {
			$adresse = new Adresse();
			$adresse->libelleAdresse = 'Adresse 1';
			$adresse->adresse = $personne->adresse;
			$adresse->cp = $personne->codepostal;
			$adresse->commune = $personne->commune;
			$membre->adresses = array($adresse);
		}
		// Affichage du formulaire
		$Model['titre_page']    = "Nouveau membre";
		$Model['corps_page']    = static::$PATH_VIEW_CONVERT;
		$Model['entity']        = $membre;
		$Model['entityDelete']  = $personne;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function incAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$personne = $params['entity'];
		$personne->nbessais = $personne->nbessais + 1;
		$personne->update();
		throw new Exception('MSG-QUERYESSAISINC');
	}

}