<?php
namespace controllers;

use lib\EntityController;
use lib\DBConnexion;
use lib\Courriel;
use lib\Exception;
use lib\GoPrevException;
use lib\security\Security;
use lib\Navigation;

use entities\Randonnee;
use entities\Parcour;
use entities\Programme;
use entities\Programme_Parcour;
use entities\Membre;
use entities\Personne;
use entities\Participant;
use entities\Programme_Synthese;
use entities\Programme_Fichier;
use entities\Participant_Parcour;

class ProgrammeController extends EntityController
{
	public static $SECURITY          = array(
		'list'           => array(2,3,4,5,8), 
		'display'        => array(2,3,4,5,8), 
		'insert'         => array(2,5), 
		'update'         => array(0,5), 
		'delete'         => array(0,5), 
		'valide'         => array(5), 
		'cancel'         => array(5), 
		'reactivation'   => array(5), 
		'participants'   => array(0,2,3,4,5,8), 
		'addParticipant' => array(0,5),
		'newParticipant' => array(0,5),
		'ventile'        => array(0,5),
		'synthese'       => array(0,5), 
		'valideSynthese' => array(5),
		'listFichiers'   => true,
		);
	
	protected static $ENTITY = "entities\Programme";
	protected static $PATH_VIEW_LIST         = 'views/programme/list.php';
	protected static $PATH_VIEW_INSERT       = 'views/programme/insert.php';
	protected static $PATH_VIEW_UPDATE       = 'views/programme/insert.php';
	protected static $PATH_VIEW_DELETE       = 'views/programme/delete.php';
	protected static $PATH_VIEW_DISPLAY      = 'views/programme/display.php';
	protected static $PATH_VIEW_VENTILE      = 'views/participant/ventile.php';
	protected static $PATH_VIEW_PARTICIPANTS = 'views/participant/list.php';
	protected static $PATH_VIEW_NEWPERS      = 'views/personne/add.php';
	protected static $PATH_VIEW_FICHIERS     = 'views/programme_fichier/list.php';

	public function listAction($params=null)
	{
		$Model['titre_page'] = "Liste des randonnées programmées";
		$Model['datedebut']  = '01/'.date('m/Y');
		$Model['onglet']     = 'programmees';
		$entity = static::$ENTITY;
		$sort   = "datedepart ASC";
		$filtre = "valide != 3";
		
		if ( isset($_GET['onglet']) ) $Model['onglet'] = $_GET['onglet'];
		if ( $Model['onglet'] == 'annulees' ) {
			$Model['datedebut']  = '';
			$filtre = "valide = 3";
		}
		if ( !empty($_GET['id_responsable']) ) $Model['id_responsable'] = $_GET['id_responsable'];
		if ( !empty($_GET['id_typerando']) )   $Model['id_typerando']   = $_GET['id_typerando'];
			
		if ( isset($_POST['validForm']) ) {
			if ( !empty($_POST['datedebut']) )      $Model['datedebut']      = $_POST['datedebut'];
			else $Model['datedebut'] = '';
			if ( !empty($_POST['datefin']) )        $Model['datefin']        = $_POST['datefin'];
			else $Model['datefin'] = '';
			if ( !empty($_POST['id_responsable']) ) $Model['id_responsable'] = $_POST['id_responsable'];
			if ( !empty($_POST['id_typerando']) )   $Model['id_typerando']   = $_POST['id_typerando'];
			Navigation::putFiltre($Model); 
		}
		elseif ( $filtres = Navigation::callFiltre() ) {
			$Model = $filtres;
			Navigation::putFiltre($Model); 
		}
		$filtre = $this->createFiltre( $Model , $filtre );

		$Model['corps_page']    = static::$PATH_VIEW_LIST;
		$Model['lstEntities']   = $entity::filtreTypeRando ( $entity::selectList($filtre,$sort) , $Model['id_typerando'] );
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	private function createFiltre( $Model , $filtre ) 
	{
		if ( !empty($Model['id_responsable']) ) {
			if ( !empty($filtre) ) $filtre .= " AND ";
			$filtre .= "id_responsable = ".$Model['id_responsable'];
		}
		if ( !empty($Model['datedebut']) ) {
			if ( !empty($filtre) ) $filtre .= " AND ";
			$filtre .= "datedepart >= STR_TO_DATE('".DBConnexion::SQLEncode($Model['datedebut'])."','%d/%m/%Y')";
		}
		if ( !empty($Model['datefin']) ) {
			if ( !empty($filtre) ) $filtre .= " AND ";
			$filtre .= "datedepart < STR_TO_DATE('".DBConnexion::SQLEncode($Model['datefin'])." 23:59','%d/%m/%Y') + INTERVAL 1 DAY";
		}
		return $filtre;
	}

	public function insertAction($params=null)
	{
		if ( isset($_POST['validForm']) ) {
			// Validation d'un Formulaire
			$programme = new Programme($_POST);
			if ( $programme->nbparcours == 0 ) {
				throw new Exception("ERR-NBPARCOURS");
			}
			$telInscrip = $programme->telinscription;
			if ( empty($telInscrip) ) {
				$programme->telinscription = $programme->id_inscription->telephone;
			}
			$programme->id_createur = Security::getConnectedUser()->id;
			$programme->insert(true);
			foreach ( $programme->animateurs as $animateur ) {
				$participant = new Participant();
				$participant->id_programme = $programme;
				$participant->id_membre = $animateur->id_animateur;
				$participant->insert(true);
			}
			Courriel::newPrevisionMail($programme,'prev');
			throw new GoPrevException('MSG-QUERYINSERT');
		}
		
		// Affichage du formulaire
		$programme = new Programme();
		$programme->id_responsable = Security::getConnectedUser()->id;
		$programme->id_inscription = Security::getConnectedUser()->id;
		if ( isset($_GET['id_Parcour']) ) {
			$parcour = new Parcour(intval($_GET['id_Parcour']));
			$prog_parcour = new Programme_Parcour();
			$prog_parcour->id_parcour = $parcour;
			$programme->parcours = array( $prog_parcour );
			$programme->id_randonnee = new Randonnee($parcour->id_randonnee->id);
			$Model['id_typerando'] = $programme->id_randonnee->id_typerando->id;
			$Model['departement']  = $programme->id_randonnee->departement;
			$Model['commune']      = $programme->id_randonnee->commune;
			$Model['lieu']         = $programme->id_randonnee->lieu;
		}
		if ( isset($_GET['id_randonnee']) || isset($_POST['id_randonnee']) ) {
			$id = 0;
			if ( isset($_GET['id_randonnee']) )  $id = intval($_GET['id_randonnee']);
			if ( isset($_POST['id_randonnee']) ) $id = intval($_POST['id_randonnee']);
			$programme->id_randonnee = new Randonnee($id);
			$Model['id_typerando'] = $programme->id_randonnee->id_typerando->id;
			$Model['departement']  = $programme->id_randonnee->departement;
			$Model['commune']      = $programme->id_randonnee->commune;
			$Model['lieu']         = $programme->id_randonnee->lieu;
		}
		elseif ( $prog = Navigation::callFiltre() ) {
			$programme->id_randonnee = $prog->id_randonnee;
			$Model['id_typerando'] = $programme->id_randonnee->id_typerando->id;
			$Model['departement']  = $programme->id_randonnee->departement;
			$Model['commune']      = $programme->id_randonnee->commune;
			$Model['lieu']         = $programme->id_randonnee->lieu;
		}
		else {
			if ( !empty($_POST['id_typerando']) ) {
				$Model['id_typerando'] = $_POST['id_typerando'];
			}
			if ( !empty($_POST['departement']) ) {
				$Model['departement'] = $_POST['departement'];
				if ( !empty($_POST['commune']) ) {
					$Model['commune'] = $_POST['commune'];
					if ( !empty($_POST['lieu']) ) {
						$Model['lieu'] = $_POST['lieu'];
						$lst = Randonnee::selectList("departement = '".$Model['departement']."' AND commune = '".$Model['commune']."' AND lieu = '".$Model['lieu']."' ");
						if ( count($lst) == 1 ) $programme->id_randonnee = current($lst);
					}
				}
			}
		}
		$Model['titre_page']     = "Nouveau programme";
		$Model['corps_page']     = static::$PATH_VIEW_INSERT;
		$Model['entity']         = $programme;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function updateAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$programme = $params['entity'];
		if ( $programme->valide != 0 && !Security::isCoordinateur() && !Security::isAdmin() ) throw new Exception('ERR-USER-NOTHABILIT');
		if ( isset($_POST['validForm']) ) 
		{
			// Validation d'un Formulaire
			$programme->setAttributes($_POST);
			if ( $programme->nbparcours == 0 ) {
				throw new Exception("ERR-NBPARCOURS");
			}
			$telInscrip = $programme->telinscription;
			if ( empty($telInscrip) ) {
				$programme->telinscription = $programme->id_inscription->telephone;	
			}
			$programme->valide = 0;
			$programme->update(true);
			$lstParticipants = $programme->participants;
			foreach ( $programme->animateurs as $animateur ) 
			{
				if ( ! $programme->isParticipant( $animateur->id_animateur->id ) )
				{
					$participant = new Participant();
					$participant->id_programme = $programme;
					$participant->id_membre = $animateur->id_animateur;
					$participant->insert(true);
				}
			}
			throw new GoPrevException('MSG-QUERYUPDATE');
		}
		
		// Affichage du formulaire
		$Model['id_typerando']  = $programme->randonnee->id_typerando->id;
		$Model['departement']   = $programme->randonnee->departement;
		$Model['commune']       = $programme->randonnee->commune;
		$Model['lieu']          = $programme->randonnee->lieu;
		$Model['titre_page']    = "Modification d'un programme";
		$Model['corps_page']    = static::$PATH_VIEW_UPDATE;
		$Model['entity']        = $programme;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function deleteAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception ( 'ERR-PARAM-NOID' );
		$entity = $params['entity'];
		if ( Security::isProprio( $entity->id_responsable->id ) && !Security::isAdmin() && $entity->valide != 0 ) throw new Exception('ERR-USER-NOTHABILIT');
		if ( isset($_POST['validForm']) ) {
			// Validation d'un Formulaire
			$entity->delete(true);
			throw new GoPrevException('MSG-QUERYDELETE');
		}
		// Affichage du formulaire
		$Model['titre_page']    = "Suppression d'un élément";
		$Model['corps_page']    = static::$PATH_VIEW_DELETE;
		$Model['entity']        = $entity;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function valideAction($params=null)
	{
		// Affichage du formulaire
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$entity = $params['entity'];
		$entity->valide = 1;
		$entity->update(true);
		throw new Exception();
	}

	public function cancelAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception ( 'ERR-NOID' );
		$programme = $params['entity'];
		$programme->valide = 3;
		$programme->update(true);
		throw new Exception('MSG-QUERYUPDATE');
	}

	public function reactivationAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$programme = $params['entity'];
		// Affichage du formulaire
		$programme->datedepart  = date('d/m/Y');
		$programme->getAttribut('participants')->deleteAll();
		$programme->update(true);
		$programme->valide      = 0;
		$Model['id_typerando']  = $programme->randonnee->id_typerando->id;
		$Model['departement']   = $programme->randonnee->departement;
		$Model['commune']       = $programme->randonnee->commune;
		$Model['lieu']          = $programme->randonnee->lieu;
		$Model['titre_page']    = "Réactivation d'un programme";
		$Model['corps_page']    = static::$PATH_VIEW_UPDATE;
		$Model['entity']        = $programme;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function participantsAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$Model['entity']        = $params['entity'];
		$Model['titre_page']    = "Gestion des participants à une randonnée";
		$Model['corps_page'] = static::$PATH_VIEW_PARTICIPANTS;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function addParticipantAction($params=null)
	{
		if ( empty($_POST['nomparticipant']) ) throw new Exception('ERR-FORM-OBLIGAT ',array( 'ATTRIBNAME' => 'nomparticipant' ));
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$programme = $params['entity'];
		$participant = new Participant();
		$participant->id_programme = $programme;
		$lst = Membre::selectList("'".$_POST['nomparticipant']."' LIKE CONCAT(nom,' ',prenom) AND id_etat IN (1,2)");
		if ( count($lst) == 1 ) $participant->id_membre = current($lst);
		else {
			$lst = Personne::selectList("'".$_POST['nomparticipant']."' LIKE CONCAT(nom,' ',prenom)");
			if ( count($lst) == 1 ) {
				$personne = current($lst);
				$personne->nbessais = $personne->nbessais+1;
				$participant->id_personne = $personne;
			}
		}
		if ( $participant->id_membre == null && $participant->id_personne == null ) {
			throw new Exception('MSG-PERSONNEINTROUVABLE');
		}
		if ( $participant->programme->inscrits >= $participant->programme->nbplaces ) {
			$participant->attente = 1;
		}
		$participant->insert();
		$msg = null;
		if ( ! $participant->membre->certifValide($programme->randonnee) ) $msg = "WAR-CERTIFINVALIDE";
		throw new Exception($msg);
	}

	public function newParticipantAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$programme = $params['entity'];
		if ( isset($_POST['validForm']) ) {
			// Validation d'un Formulaire
			$personne = new Personne($_POST);
			$personne->id = null;
			$personne->nbessais = 1;
			$participant = new Participant();
			$participant->id_personne = $personne;
			$participant->id_programme = $programme;
			if ( $participant->id_programme->inscrits >= $participant->id_programme->nbplaces ) 
			{
				$participant->attente = 1;
			}
			$participant->insert(true);
			throw new Exception('MSG-QUERYINSERT');
		}
		$Model['entity']        = new Personne();
		$Model['id_programme']  = $programme->id;
		$Model['titre_page']    = "Créer une nouvelle personne";
		$Model['corps_page']    = static::$PATH_VIEW_NEWPERS;
		return array(static::$PATH_VIEW_NEWPERS,$Model,true);
	}

	public function ventileAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		if ( empty($_GET['id_participant']) && empty($_GET['id_parcour']) ) {
			$Model['entity']        = $params['entity'];
			$Model['titre_page']    = "Ventilation des participants à une randonnée";
			$Model['corps_page'] = static::$PATH_VIEW_VENTILE;
			return array(static::$PATH_VIEW_LAYOUT,$Model);
		}
		$participant = new Participant( intval($_GET['id_participant']) );
		$parcours = $participant->parcours;
		foreach ( $parcours as $parcour ) $parcour->delete(true);
		$entity = new Participant_Parcour();
		$entity->id_participant = intval($_GET['id_participant']);
		$entity->id_parcour = intval($_GET['id_parcour']);
		$entity->insert(true);
		return array('',null,true);
	}

	public function syntheseAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$programme = $params['entity'];
		if ( isset($_POST['validForm']) ) {
			$programme->setAttributes($_POST);
			$programme->update();
			Courriel::newPrevisionMail($programme,'synthese_rando');
			throw new GoPrevException('MSG-QUERYUPDATE');
		}
		// Affichage du formulaire
		$Model['titre_page']    = "Synthese de la randonnée";
		$Model['corps_page']    = 'views/synthese/syntheseProgramme.php';
		$Model['entity']        = $programme;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function valideSyntheseAction($params=null)
	{
		// Affichage du formulaire
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$entity = $params['entity'];
		if ( $entity->synthese == null ) throw new Exception('Synthèse pas encore renseignée');
		$synthese = $entity->synthese;
		$synthese->valide = 1;
		$synthese->update(true);
		Courriel::newPrevisionMail($entity,'valid_synthese_rando');
		throw new Exception();
	}

	public function listFichiersAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$entity = $params['entity'];
		$Model['titre_page']  = "Liste des Fichiers pour la randonnée";
		$Model['corps_page']  = static::$PATH_VIEW_FICHIERS;
		$Model['entity']      = $entity;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

}