<?php
namespace entities;

use lib\Entity;
use lib\security\Security;
use lib\attributs\Chaine;
use lib\attributs\Texte;
use lib\attributs\DateHeure;
use lib\attributs\Relation;

class Actualite extends Entity
{
	public static $COL_ID           = 'id';
	public static $COL_DATECREATION = 'datecreation';
	public static $COL_TITRE        = 'titre';
	public static $COL_CONTENU      = 'contenu';
	public static $COL_CREATEUR     = 'id_createur';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_DATECREATION => new DateHeure(static::$COL_DATECREATION,date("Y-m-d H:i:s"), false, false, true),
			static::$COL_TITRE        => new Chaine(static::$COL_TITRE),
			static::$COL_CONTENU      => new Texte(static::$COL_CONTENU,null,true),
			static::$COL_CREATEUR     => new Relation(static::$COL_CREATEUR,Security::getConnectedUser(),'entities\\Membre'),		
		);
	}
	
    public function __toString()
    {
		$titre = static::$COL_TITRE;
        return $this->$titre;
    }

	public function __get($name)
	{
		switch ( $name )
    	{
     		case 'createur' :
    			return $this->attributs[static::$COL_CREATEUR]->value;
    			break;
    		default:
    			return parent::__get($name);
    			break;
    	}
	}

}

?>
