<?php
namespace entities;

use lib\Entity;
use lib\attributs\Chaine;
use lib\attributs\Texte;

class Etat extends Entity
{
	public static $COL_ID          = 'id';
	public static $COL_LIBELLE     = 'libelle';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_LIBELLE     => new Chaine(static::$COL_LIBELLE),
		);
	}
	
    public function __toString()
    {
		$libelle = static::$COL_LIBELLE;
        return (string)$this->$libelle;
    }

	public static function displayList($init=0,$obligatoire=false)
	{
		$lst = static::selectList();
		$str  = '<SELECT name="id_etat">';
		if ( !$obligatoire ) $str .= '	<option value="">Sélectionnez un état ...</option>';
		foreach ( $lst as $etat ) {
			$selected = "";
			if ( $init == $etat->id ) $selected = "SELECTED";
			$str .= '	<option value="'.$etat->id.'" '.$selected.'>'.$etat->libelle.'</option>';
		}
		$str .= '</SELECT>';
		return $str;
	}

}

?>
