<?php
namespace entities;

use lib\Entity;
use lib\attributs\DateHeure;
use lib\attributs\File;
use lib\attributs\Chaine;
use lib\attributs\Texte;
use lib\attributs\Relation;

class Evenement extends Entity
{
	public static $COL_ID           = 'id_evenement';
	public static $COL_UPLOADFILE   = 'uploadfile';
	public static $COL_TITRE        = 'titre';
	public static $COL_MIME         = 'mime';
	public static $COL_TAILLE       = 'taille';
	public static $COL_DATEUPLOAD   = 'dateupload';
	public static $COL_DESCRIPTION  = 'description';
	public static $COL_REPERTOIRE   = 'repertoire';
	public static $COL_CREATEUR     = 'id_createur';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_UPLOADFILE  => new File(static::$COL_UPLOADFILE,null,array('name' => static::$COL_TITRE, 'mime' => static::$COL_MIME, 'size' => static::$COL_TAILLE)),
			static::$COL_DATEUPLOAD  => new DateHeure(static::$COL_DATEUPLOAD,date("Y-m-d H:i:s"), false,false, true),
			static::$COL_DESCRIPTION => new Texte(static::$COL_DESCRIPTION,null,true),
			static::$COL_REPERTOIRE  => new Chaine(static::$COL_REPERTOIRE,null,true),
			static::$COL_CREATEUR    => new Relation(static::$COL_CREATEUR, null, 'entities\\Membre'),
		);	
	}
	
    public function __toString()
    {
    	$fichier = static::$COL_UPLOADFILE;
		return $this->$fichier->name;
    }

	public function __get($name)
	{
		switch ( $name )
    	{
    		case 'createur' :
    			return $this->attributs[static::$COL_CREATEUR]->value;
    			break;
    		case 'url' :
				$tabVals = parse_ini_file('config/params.ini');	// Charge le fichier de param�trage 
    			return $tabVals['pathData'].'/'.$this->attributs[static::$COL_REPERTOIRE]->value.'/'.$this->attributs[static::$COL_UPLOADFILE]->name;
    			break;
    		default:
    			return parent::__get($name);
    			break;
    	}
	}
	
}

?>
