<?php
namespace entities;

use lib\Entity;
use lib\attributs\DateHeure;
use lib\attributs\File;
use lib\attributs\Chaine;
use lib\attributs\Texte;
use lib\attributs\Relation;

class Fichier extends Entity
{
	public static $COL_ID           = 'id';
	public static $COL_UPLOADFILE   = 'uploadfile';
	public static $COL_TITRE        = 'name';
	public static $COL_MIME         = 'mime';
	public static $COL_TAILLE       = 'size';
	public static $COL_DATEUPLOAD   = 'dateupload';
	public static $COL_NOMFICHIER   = 'nomfichier';
	public static $COL_DESCRIPTION  = 'descriptionfichier';
	public static $COL_REPERTOIRE   = 'repertoirefichier';
	public static $COL_CREATEUR     = 'id_createur';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_UPLOADFILE  => new File(static::$COL_UPLOADFILE,null,array('name' => static::$COL_TITRE, 'mime' => static::$COL_MIME, 'size' => static::$COL_TAILLE)),
			static::$COL_DATEUPLOAD  => new DateHeure(static::$COL_DATEUPLOAD,date("Y-m-d H:i:s"), false,false, true),
			static::$COL_NOMFICHIER  => new Chaine(static::$COL_NOMFICHIER,null,true),
			static::$COL_DESCRIPTION => new Texte(static::$COL_DESCRIPTION,null,true),
			static::$COL_REPERTOIRE  => new Chaine(static::$COL_REPERTOIRE,null,true),
			static::$COL_CREATEUR    => new Relation(static::$COL_CREATEUR, null, 'entities\\Membre'),
		);	
	}

	public function __toString()
	{
		$aff = '';
		switch ( $this->group ) {
			case 'image' :
				$aff = '<IMG src="' . $this->url . '" alt="' . $this->name . '" />';
				break;
			default :
				$aff = $this->name;
				break;
		}
		return '<A href="_Fichier_download&entity='.static::$NAME_ENTITY.'&id='. $this->id.'" title="' . $this->descriptionfichier . '">'.$aff.'</A>';
	}

	public function __get($name)
	{
		switch ( $name )
		{
			case 'createur' :
				return $this->attributs[static::$COL_CREATEUR]->value;
				break;
			case 'url' :
				$repcol = static::$COL_REPERTOIRE;
				$rep = ( $this->$repcol != null ) ? '/'.$this->$repcol : '';
				return Parametres::get("pathFiles") . $rep . '/' . $this->nomfichier;
				break;
			case 'name' :
				return $this->getAttribut(static::$COL_UPLOADFILE)->name ;
				break;
			case 'size' :
				return $this->getAttribut(static::$COL_UPLOADFILE)->size ;
				break;
			case 'type' :
				return strtolower(substr( $this->getAttribut(static::$COL_UPLOADFILE)->mime, strrpos($this->getAttribut(static::$COL_UPLOADFILE)->mime,'/')+1 )) ;
				break;
			case 'group' :
				return strtolower(substr( $this->getAttribut(static::$COL_UPLOADFILE)->mime, 0, strrpos($this->getAttribut(static::$COL_UPLOADFILE)->mime,'/') )) ;
				break;
			case 'extension' :
				return substr($this->getAttribut(static::$COL_UPLOADFILE)->name,strripos($this->getAttribut(static::$COL_UPLOADFILE)->name,'.')+1) ;
				break;
			default:
				return parent::__get($name);
				break;
		}
	}

	public function __set($name,$value)
	{
		switch ( $name )
		{
			case 'name' :
				$fichier = $this->getAttribut(static::$COL_UPLOADFILE)->name = $value;
				$this->attributs[static::$COL_UPLOADFILE]->isUpdate();
				break;
			case 'nomfichier' :
				if ( $this->id == null ) {
					$this->getAttribut(static::$COL_UPLOADFILE)->name = $value;
					$this->attributs[static::$COL_UPLOADFILE]->isUpdate();
				}
				break;
			default:
				return parent::__set($name,$value);
				break;
		}
	}

	public function initNomFichier()
	{
		return uniqid() . '.fic';
	}

	public function initRepFichier()
	{
		return 'programme' ;
	}

	public function getNomFichier()
	{
		return $this->getAttribut(static::$COL_NOMFIC)->value ;
	}

	public function getPathData()
	{
		$repcol = static::$COL_REPERTOIRE;
		$rep = ( $this->$repcol != null ) ? '/'.$this->$repcol : '';
		return Parametres::get("pathFiles") . $rep;
	}
	
}

?>
