<?php
namespace entities;

use lib\Entity;
use lib\attributs\Chaine;
use lib\attributs\Texte;

class Licence extends Entity
{
	public static $COL_ID      = 'id';
	public static $COL_CODE    = 'code';
	public static $COL_LIBELLE = 'libelle';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_CODE    => new Chaine(static::$COL_CODE),
			static::$COL_LIBELLE => new Chaine(static::$COL_LIBELLE,null,true),
		);
	}
	
    public function __toString()
    {
		$code = static::$COL_CODE;
        return (string)$this->$code;
    }

	public static function displayList($init=0,$obligatoire=false)
	{
		$lst = static::selectList();
		$str  = '<SELECT name="id_licence">';
		if ( !$obligatoire ) $str .= '	<option value="">Sélectionnez un type de licence ...</option>';
		foreach ( $lst as $licence ) {
			$selected = "";
			if ( $init == $licence->id ) $selected = "SELECTED";
			$str .= '	<option value="'.$licence->id.'" '.$selected.'>'.$licence->code.'</option>';
		}
		$str .= '</SELECT>';
		return $str;
	}

}

?>
