<?php
namespace entities;

use lib\security\User;
use lib\DBConnexion;
use lib\attributs\DateHeure;
use lib\attributs\Mail;
use lib\attributs\Tel;
use lib\attributs\Choix;
use lib\attributs\Chaine;
use lib\attributs\Password;
use lib\attributs\Texte;
use lib\attributs\Entier;
use lib\attributs\Relation;
use lib\attributs\Liste;
use entities\Membre_Fichier;

class Membre extends User
{
	public static $COL_PROPRIO = 'id';
	public static $COL_ID             = 'id';

	public static $COL_SEXE           = 'sexe';
	public static $COL_NOM            = 'nom';
	public static $COL_NOMJEUNEFILLE  = 'nomjeunefille';
	public static $COL_PRENOM         = 'prenom';
	public static $COL_DATENAISSANCE  = 'datenaissance';
	public static $COL_LIEUNAISSANCE  = 'lieunaissance';
	public static $COL_TELEPHONE      = 'telephone';
	public static $COL_PORTABLE       = 'portable';
	public static $COL_BALISEUR       = 'baliseur';
	public static $COL_ACTIF          = 'actif';
	public static $COL_ACTIVITEACTU   = 'activiteactu';
	public static $COL_ACTIVITEANTE   = 'activiteante';
	public static $COL_LICENCE        = 'licence';
	public static $COL_DATELICENCE    = 'datelicence';
	public static $COL_AUTRECLUB      = 'autreclub';
	public static $COL_NOTE           = 'note';
	public static $COL_COMMENTAIRES   = 'commentaire';
	public static $COL_DATEEDITION    = 'dateedition';
	public static $COL_NBESSAIS       = 'nbessais';
	public static $COL_ETAT           = 'id_etat';
	public static $COL_CREATEUR       = 'id_createur';
	public static $COL_IDLICENCE      = 'id_licence';
	public static $COL_TYPEANIMATEUR  = 'id_typeanimateur';
//	public static $COL_FICHIER        = 'id_fichier';
	public static $COL_EDITEUR        = 'id_editeur';
	
	public static $COL_FICHIERS       = 'fichiers';
	public static $COL_BREVETS        = 'brevets';
	public static $COL_CERTIFS        = 'certifs';
	public static $COL_ADRESSES       = 'adresses';
	public static $COL_CONTACTS       = 'contacts';
	public static $COL_MEMBRECA       = 'membreCA';
	public static $COL_CHEQUES        = 'cheques';
	public static $COL_ROLES          = 'roles';
//	public static $COL_PARTICIPANTS   = 'participants';

	public static $LVL_TRACES         = array( 'select' => false, 'insert' => true, 'update' => true, 'updatePwd' => true, 'delete' => true );
	public static $FIC_TRACES         = 'data/traces/MembresQuery.trc';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_SEXE           => new Choix(static::$COL_SEXE,'M',array( 'M' => 'Homme', 'F' => 'Femme')),
			static::$COL_NOM            => new Chaine(static::$COL_NOM),
			static::$COL_NOMJEUNEFILLE  => new Chaine(static::$COL_NOMJEUNEFILLE,null,true),
			static::$COL_PRENOM         => new Chaine(static::$COL_PRENOM),
			static::$COL_DATENAISSANCE  => new DateHeure(static::$COL_DATENAISSANCE,null, true),
			static::$COL_LIEUNAISSANCE  => new Chaine(static::$COL_LIEUNAISSANCE,null,true),
			static::$COL_MAIL           => new Mail(static::$COL_MAIL,null,true),
			static::$COL_TELEPHONE      => new Tel(static::$COL_TELEPHONE,null,true),
			static::$COL_PORTABLE       => new Tel(static::$COL_PORTABLE,null,true),
			static::$COL_BALISEUR       => new Choix(static::$COL_BALISEUR,0,array( 0 => 'Non', 1 => 'Oui')),
			static::$COL_ACTIF          => new Choix(static::$COL_ACTIF,0,array( 0 => 'Non', 1 => 'Oui')),
			static::$COL_ACTIVITEACTU   => new Chaine(static::$COL_ACTIVITEACTU,null,true),
			static::$COL_ACTIVITEANTE   => new Chaine(static::$COL_ACTIVITEANTE,null,true),
			static::$COL_LICENCE        => new Chaine(static::$COL_LICENCE,null,true),
			static::$COL_DATELICENCE    => new DateHeure(static::$COL_DATELICENCE,null, true),
			static::$COL_AUTRECLUB      => new Chaine(static::$COL_AUTRECLUB,null, true),
			static::$COL_NOTE           => new Texte(static::$COL_NOTE,null,true),
			static::$COL_COMMENTAIRES   => new Texte(static::$COL_COMMENTAIRES,null,true),
			static::$COL_DATEEDITION    => new DateHeure(static::$COL_DATEEDITION,null, true),
			static::$COL_NBESSAIS       => new Entier(static::$COL_NBESSAIS,0),
			static::$COL_ETAT           => new Relation(static::$COL_ETAT, null, 'entities\\Etat'),
			static::$COL_CREATEUR       => new Relation(static::$COL_CREATEUR, null, 'entities\\Membre'),
			static::$COL_IDLICENCE      => new Relation(static::$COL_IDLICENCE, null, 'entities\\Licence',null,true),
			static::$COL_TYPEANIMATEUR  => new Relation(static::$COL_TYPEANIMATEUR, null, 'entities\\TypeAnimateur',null,true),
//			static::$COL_FICHIER        => new Relation(static::$COL_FICHIER, null, 'entities\\Membre_Fichier',null,true),
			static::$COL_EDITEUR        => new Relation(static::$COL_EDITEUR, null, 'entities\\Membre',null,true),		
			
//			static::$COL_MEMBRECA       => new Liste(static::$COL_MEMBRECA,null, 'entities\\CAmembre','id_membre'),
			static::$COL_FICHIERS       => new Liste(static::$COL_FICHIERS, null, 'entities\\Membre_Fichier','id_membre','id_fichier'),
			static::$COL_ADRESSES       => new Liste(static::$COL_ADRESSES,null, 'entities\\Adresse','id_membre','libelleAdresse'),
			static::$COL_CONTACTS       => new Liste(static::$COL_CONTACTS,null, 'entities\\Prevenir','id_membre','numeroContact'),
			static::$COL_CHEQUES        => new Liste(static::$COL_CHEQUES,null, 'entities\\Cheque','id_membre','montantCheque'),
			static::$COL_BREVETS        => new Liste(static::$COL_BREVETS,null, 'entities\\Brevet','id_membre','id_typebrevet'),
			static::$COL_CERTIFS        => new Liste(static::$COL_CERTIFS,null, 'entities\\Certificat_Membre','id_membre','id_typecertificat'),
			static::$COL_ROLES          => new Liste(static::$COL_ROLES,null, 'entities\\Role_Membre','id_membre','id_role'),
//			static::$COL_PARTICIPANTS   => new Liste(static::$COL_PARTICIPANTS,null,'entities\\Participant','id_membre','id_participant','datecreation'),
		);	
	}
	
    public function inRole($idRole)
    {
    	$roles = static::$COL_ROLES;
    	foreach ( $this->$roles as $userRole )
    	{
    		if ( $userRole->id_role->id == $idRole ) return true;
    	}
    	return false;
    }
	
	public function displayAdresses()
	{
		$pos = 0;
		foreach ( $this->adresses as $adresse ) {
			include "views/adresse/display.php";
			$pos++;
		}
	}
	
	public function displayBrevets()
	{
		$pos = 0;
		foreach ( $this->brevets as $brevet ) {
			include "views/brevet/display.php";
			$pos++;
		}
	}
	
	public function displayCertificats()
	{
		$pos = 0;
		foreach ( $this->certifs as $certif ) {
			include "views/certificat/display.php";
			$pos++;
		}
	}
	
	public function displayContacts()
	{
		$pos = 0;
		foreach ( $this->contacts as $prevenir ) {
			include "views/prevenir/display.php";
			$pos++;
		}
	}
	
	public function displayCheques()
	{
		$pos = 0;
		foreach ( $this->cheques as $cheque ) {
			include "views/cheque/display.php";
			$pos++;
		}
	}
	
	public function displayRoles()
	{
	}
	
	public function displayMembreCA()
	{
	}
	
	public function displayPermanences()
	{
	}
	
	public function displayInscriptions()
	{
	}
	
	public function displayParticipations()
	{
	}
	
	public function displayFichiers()
	{
		$lst = $this->{static::$COL_FICHIERS};
		$ret = '';
		foreach ( $lst as $fichier ) {
			//print_r($fichier); echo "<br><br><br>";
			$ret .= (string)$fichier;
		}
		//exit;
		return $ret;
	}
	
    public function __toString()
    {
    	$nom = static::$COL_NOM;
    	$prenom = static::$COL_PRENOM;
		return $this->$nom . ' ' . $this->$prenom;
    }

	public function __get($name)
	{
		switch ( $name )
    	{
    		case 'etat' :
    			return $this->attributs[static::$COL_ETAT]->value;
    			break;
    		case 'createur' :
    			return $this->attributs[static::$COL_CREATEUR]->value;
    			break;
    		case 'licence' :
    			return $this->attributs[static::$COL_LICENCE]->value;
    			break;
    		case 'typeanimateur' :
    			return $this->attributs[static::$COL_TYPEANIMATEUR]->value;
    			break;
    		case 'photo' :
				$lst = $this->attributs[static::$COL_FICHIERS]->value;
				if ( empty($lst) ) return null;
				else return current($lst);
    			break;
			case 'editeur' :
    			return $this->attributs[static::$COL_EDITEUR]->value;
    			break;
			case 'adresse' :
				$adddrs = $this->{static::$COL_ADRESSES};
				if ( empty($adddrs) ) return '';
    			else return current($adddrs)->getAddr();
    			break;
			case 'adresse1' :
				$adddrs = $this->{static::$COL_ADRESSES};
				if ( empty($adddrs) ) return new Adresse();
    			else return current($adddrs);
    			break;
    		default:
    			return parent::__get($name);
    			break;
    	}
	}
	
	public static function displayListAnimateurs($init=0,$obligatoire=false,$name='id_responsable',$event='')
	{
		$lst = static::selectList('id IN (SELECT id_membre FROM gari_role_membre WHERE id_role = 2)','nom,prenom');
		$str  = '<SELECT name="'.$name.'" id="'.$name.'" '.$event.'>';
		if ( !$obligatoire ) $str .= '	<option value="">Sélectionnez un responsable ...</option>';
		foreach ( $lst as $membre ) {
			$selected = "";
			if ( $init == $membre->id ) $selected = "SELECTED";
			$str .= '	<option value="'.$membre->id.'" '.$selected.'>'.(string)$membre.'</option>';
		}
		$str .= '</SELECT>';
		return $str;
	}
	
	public function activer()
	{
		$etat = static::$COL_ETAT;
		$this->$etat = 1;
	}
	
	public function aRenouveler()
	{
		$etat = static::$COL_ETAT;
		$this->$etat = 2;
	}
	
	public function archiver()
	{
		$etat = static::$COL_ETAT;
		$this->$etat = 7;
	}
	
	public function enEssai()
	{
		$etat = static::$COL_ETAT;
		$this->$etat = 8;
	}
	
	public function notActif()
	{
		if ($this->attributs[static::$COL_ETAT]->value->id == 1) return false;
		else return true;
	}
	
	public function notArchive()
	{
		if ($this->attributs[static::$COL_ETAT]->value->id == 7) return false;
		else return true;
	}
	
	public function certifValide($rando) {
		$certificat = $rando->typerando->typecertif;
		if ( empty($certificat) ) return true;
		foreach ( $this->certifs as $certif ) {
			if ( $certif->valide($certificat) ) return true;
		}
		return false;
	}

}

?>
