<?php
namespace entities;

use lib\EntityFichier;
use lib\attributs\Relation;

class Membre_Fichier extends EntityFichier
{
	public static $NAME_CTRLEUR = 'Membre';
	public static $COL_ID       = 'id_fichier';
	public static $COL_MEMBRE   = 'id_membre';

	protected static $TYPES = array( 
			'png' => true, 'gif' => true, 'jpg' => true, 'jpeg' => true, 
		);
		
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_MEMBRE => new Relation(static::$COL_MEMBRE,null,'entities\\Membre')
		);	
	}

	protected function addGetter($name)
	{
		switch ( $name )
		{
			case 'membre' :
				return $this->attributs[static::$COL_MEMBRE]->value;
				break;
		}
		return false;
	}
		
	public function initNomFichier()
	{
		return 'MEMB_' . uniqid() . '.fic';
	}

	public function initRepFichier()
	{
		return 'membres' ;
	}
	
}

?>
