<?php
namespace entities;

use lib\Entity;
use lib\attributs\Chaine;

class Parametre extends Entity
{
	public static $COL_ID      = 'nom';
	public static $COL_NOM     = 'nom';
	public static $COL_LIBELLE = 'libelle';
	public static $COL_TYPE    = 'type';
	public static $COL_VALEUR  = 'valeur';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_TYPE   => new Chaine(static::$COL_TYPE),
			static::$COL_LIBELLE   => new Chaine(static::$COL_LIBELLE),
			static::$COL_VALEUR => new Chaine(static::$COL_VALEUR),
		);	
	}
	
    public function __toString()
    {
    	$libelle = static::$COL_LIBELLE;
		return $this->$libelle;
    }

	public function __get($name)
	{
		switch ( $name )
    	{
    		case 'nom' :
    			return $this->id;
    			break;
    		default:
    			return parent::__get($name);
    			break;
    	}
	}
	
	protected function displayClauseWhere()
	{
		$id = static::$COL_ID;
		return static::$COL_ID." LIKE '".$this->$id."'";
	}
	
}

?>
