<?php
namespace entities;

use lib\EntityFichier;
use lib\attributs\Relation;

class Parcour_Fichier extends EntityFichier
{
	public static $NAME_ENTITY  = 'Parcour';
	public static $COL_PARCOUR  = 'id_parcour';
	
	public function initAttributs() 
	{
		parent::initAttributs();
		$this->attributs[static::$COL_PARCOUR] = new Relation(static::$COL_PARCOUR,null,'entities\\Parcour') ;
	}

	public function __get($name)
	{
		switch ( $name )
		{
			case 'parcour' :
				return $this->attributs[static::$COL_PARCOUR]->value;
				break;
			default:
				return parent::__get($name);
				break;
		}
	}

	public function initNomFichier()
	{
		return 'PARC_' . uniqid() . '.fic';
	}

	public function initRepFichier()
	{
		return 'parcours' ;
	}
	
}

?>
