<?php
namespace entities;

use lib\Entity;
use lib\DBConnexion;
use lib\attributs\DateHeure;
use lib\attributs\Mail;
use lib\attributs\Tel;
use lib\attributs\Choix;
use lib\attributs\Chaine;
use lib\attributs\Texte;
use lib\attributs\Entier;
use lib\attributs\Liste;

class Personne extends Entity
{
	public static $COL_ID             = 'id';
	public static $COL_SEXE           = 'sexe';
	public static $COL_NOM            = 'nom';
	public static $COL_PRENOM         = 'prenom';
	public static $COL_DATENAISSANCE  = 'datenaissance';
	public static $COL_MAIL           = 'mail';
	public static $COL_TELEPHONE      = 'telephone';
	public static $COL_ADRESSE        = 'adresse';
	public static $COL_COMMUNE        = 'commune';
	public static $COL_CP             = 'codepostal';
	public static $COL_NBESSAIS       = 'nbessais';
	public static $COL_NOTE           = 'note';
	public static $COL_PARTICIPANTS   = 'participants';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_SEXE           => new Choix(static::$COL_SEXE,'M',array( 'M' => 'Homme', 'F' => 'Femme')),
			static::$COL_NOM            => new Chaine(static::$COL_NOM),
			static::$COL_PRENOM         => new Chaine(static::$COL_PRENOM,null, true),
			static::$COL_DATENAISSANCE  => new DateHeure(static::$COL_DATENAISSANCE,null, true),
			static::$COL_MAIL           => new Mail(static::$COL_MAIL,null,true),
			static::$COL_TELEPHONE      => new Tel(static::$COL_TELEPHONE,null,true),
			static::$COL_COMMUNE        => new Chaine(static::$COL_COMMUNE,null,true),
			static::$COL_CP             => new Chaine(static::$COL_CP,null,true),
			static::$COL_NBESSAIS       => new Entier(static::$COL_NBESSAIS,0),
			static::$COL_NOTE           => new Texte(static::$COL_NOTE,null,true),
			static::$COL_PARTICIPANTS   => new Liste(static::$COL_PARTICIPANTS,null,'entities\\Participant','id_personne','id_participant','datecreation'),
		);
	}
	
    public function __toString()
    {
    	$nom = static::$COL_NOM;
    	$prenom = static::$COL_PRENOM;
		return $this->$nom . ' ' . $this->$prenom;
    }
	
	public static function convertToMembre($membre)
	{
		$filtre = "nom LIKE '".$membre->nom."' AND prenom LIKE '".$membre->prenom."'";
		$lst = Personne::selectList($filtre);
		if ( count($lst) > 1 ) return false;
		elseif ( count($lst) == 0 ) return 0;
		else {
			$personne = current($lst);
			$colPart = static::$COL_PARTICIPANTS;
			foreach (  $this->$colPart as $participant )
			{
				$participant->id_membre = $membre->id;
				$participant->id_personne = null;
				$participant->update(true);
			}
			$personne->delete(true);
			return 1;
		}
	}

	public function certifValide($rando) {
		return true;
	}

}

?>
