<?php
namespace entities;

use lib\Entity;
use lib\attributs\Chaine;
use lib\attributs\Entier;
use lib\attributs\Relation;

class Prevenir extends Entity
{
	public static $COL_ID     = 'id_prevenir';
	public static $COL_ORDRE  = 'ordreContact';
	public static $COL_NOM    = 'nomContact';
	public static $COL_NUMERO = 'numeroContact';
	public static $COL_MEMBRE = 'id_membre';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_ORDRE  => new Entier(static::$COL_ORDRE,1),
			static::$COL_NOM    => new Chaine(static::$COL_NOM,null,true),
			static::$COL_NUMERO => new Chaine(static::$COL_NUMERO),
			static::$COL_MEMBRE => new Relation(static::$COL_MEMBRE, null, 'entities\\Membre'),		
		);
	}
	
    public function __toString()
    {
		$nom = static::$COL_NOM;
		$numero = static::$COL_NUMERO;
        return $this->$numero.' ('.$this->$nom.')';
    }

}

?>
