<?php
namespace entities;

use lib\Entity;
use lib\security\Security;
use lib\attributs\DateHeure;
use lib\attributs\Choix;
use lib\attributs\Chaine;
use lib\attributs\Entier;
use lib\attributs\Texte;
use lib\attributs\Relation;
use lib\attributs\Liste;
use lib\attributs\Tel;
use entities\Participant;

class Programme extends Entity
{
	public static $COL_ID              = 'id';
	public static $COL_DATEDEPART      = 'datedepart';
	public static $COL_HEUREDEPART     = 'heuredepart';
	public static $COL_NOTE            = 'note';
	public static $COL_COMMUNEDEPART   = 'communedepart';
	public static $COL_LIEUDEPART      = 'depart_lieu';
	public static $COL_VEHICULE        = 'vehicule';
	public static $COL_NBPLACES        = 'nbplaces';
	public static $COL_APARTIR         = 'apartir';
	public static $COL_VALIDE          = 'valide';
	public static $COL_DATECREATION    = 'datecreation';
	public static $COL_CREATEUR        = 'id_createur';
	public static $COL_RESPONSABLE     = 'id_responsable';
	public static $COL_IDINSCRIPTION   = 'id_inscription';
	public static $COL_DATEINSCRIPTION = 'dateinscription';
	public static $COL_TELINSCRIPTION  = 'telinscription';
	public static $COL_RANDONNEE       = 'id_randonnee';
	public static $COL_ANIMATEURS      = 'animateurs';
	public static $COL_PARCOURS        = 'parcours';
	public static $COL_PARTICIPANTS    = 'participants';
	public static $COL_ATTENTES        = 'attentes';
	public static $COL_SYNTHESE        = 'syntheses';
	public static $COL_FICHIERS        = 'fichiers';

	public static $LVL_TRACES = array( 
		'list'           => false, 
		'display'        => false, 
		'display'        => false, 
		'insert'         => true, 
		'update'         => true, 
		'delete'         => true, 
		'cancel'         => true, 
		'reactivation'   => true, 
		'participants'   => false, 
		'addParticipant' => false, 
		'newParticipant' => false, 
		'ventile'        => true, 
		'synthese'       => true, 
		'valideSynthese' => true, 
		);
	public static $FIC_TRACES = 'data/traces/ProgrammeQuery.trc';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_DATEDEPART      => new DateHeure(static::$COL_DATEDEPART,null),
			static::$COL_HEUREDEPART     => new DateHeure(static::$COL_HEUREDEPART,null),
			static::$COL_NOTE            => new Texte(static::$COL_NOTE,null,true),
			static::$COL_COMMUNEDEPART   => new Chaine(static::$COL_COMMUNEDEPART,'SANARY/MER',true),
			static::$COL_LIEUDEPART      => new Chaine(static::$COL_LIEUDEPART,'La Buge',true),
			static::$COL_VEHICULE        => new Chaine(static::$COL_VEHICULE,'CAR',true),
			static::$COL_NBPLACES        => new Entier(static::$COL_NBPLACES,57),
			static::$COL_APARTIR         => new Entier(static::$COL_APARTIR,0),
			static::$COL_VALIDE          => new Choix(static::$COL_VALIDE,0,array( 0 => 'Non valide', 1 => 'Valide', 3 => 'Annulée')),
			static::$COL_DATECREATION    => new DateHeure(static::$COL_DATECREATION,date("Y-m-d H:i:s"), false,false, true),
			static::$COL_CREATEUR        => new Relation(static::$COL_CREATEUR, null, 'entities\\Membre'),
			static::$COL_RESPONSABLE     => new Relation(static::$COL_RESPONSABLE,null,'entities\\Membre'),
			static::$COL_RANDONNEE       => new Relation(static::$COL_RANDONNEE, null, 'entities\\Randonnee'),
			static::$COL_ANIMATEURS      => new Liste(static::$COL_ANIMATEURS,null, 'entities\\Programme_Animateur','id_programme','id_animateur','position'),
			static::$COL_PARCOURS        => new Liste(static::$COL_PARCOURS, null, 'entities\\Programme_Parcour','id_programme','id_parcour','difficulte'),
			static::$COL_PARTICIPANTS    => new Liste(static::$COL_PARTICIPANTS, null, 'entities\\Participant','id_programme','attente','nom,prenom',null,false,false,false,'attente=0'),
			static::$COL_ATTENTES        => new Liste(static::$COL_ATTENTES, null, 'entities\\Participant','id_programme','attente','datecreation',null,false,false,false,'attente=1'),
			static::$COL_IDINSCRIPTION   => new Relation(static::$COL_IDINSCRIPTION,null,'entities\\Membre',null,true),
			static::$COL_DATEINSCRIPTION => new DateHeure(static::$COL_DATEINSCRIPTION,null,true),
			static::$COL_TELINSCRIPTION  => new Tel(static::$COL_TELINSCRIPTION,null,true),
			static::$COL_SYNTHESE        => new Liste(static::$COL_SYNTHESE, null, 'entities\\Programme_Synthese','id_programme','id_synthese','datecreation'),
			static::$COL_FICHIERS        => new Liste(static::$COL_FICHIERS, null, 'entities\\Programme_Fichier','id_programme','id_fichier','dateupload'),
		);	
	}
	
    public function __toString()
    {
    	$daterando = static::$COL_DATEDEPART;
		$commune   = static::$COL_COMMUNEDEPART;
		$lieu      = static::$COL_LIEUDEPART;
		return $this->randonnee->lieu.", ".$this->randonnee->commune." le ".$this->getAttribut(static::$COL_DATEDEPART)->date.' ('.(string)$this->id_responsable.')';
    }

	public function __get($name)
	{
		switch ( $name )
    	{
    		case 'createur' :
    			return $this->attributs[static::$COL_CREATEUR]->value;
    			break;
    		case 'nbparcours' :
				$nb = 0;
				foreach ( $this->parcours as $parc ) 
				{
					if ( $parc->changed != 3 ) $nb++;
				}
    			return $nb;
				//exit;
    			break;
    		case 'randonnee' :
    			return $this->attributs[static::$COL_RANDONNEE]->value;
    			break;
    		case 'responsable' :
    			return $this->attributs[static::$COL_RESPONSABLE]->value;
    			break;
    		case 'inscription' :
    			return $this->attributs[static::$COL_IDINSCRIPTION]->value;
    			break;
     		case 'inscrits' :
    			return count($this->participants);
   			break;
     		case 'enAttente' :
    			return count($this->attentes);
    			break;
     		case 'code' :
				if ( count($this->fichiers) > 0 ) {
					$lst = $this->fichiers;
					$fichier = current($lst);
					return substr($fichier->name,3,stripos($fichier->name,'.')-3);
				}
    			return uniqid();
    			break;
    		case 'synthese' :
				$lst = $this->syntheses;
				if ( empty($lst) ) return null;
    			else return current($lst);
    			break;
			default:
    			return parent::__get($name);
    			break;
    	}
	}

	public function afficheParcours($hasBotton=false)
	{
		$cpt = 1;
		foreach ( $this->getAttribut('parcours')->value as $par ) {
			$Model['entityRel'] = $par->id_parcour;
			$Model['entity']    = $this;
			$Model['pos']       = $cpt++;
			$Model['boutons']   = $hasBotton;
			$Model['parent']    = 'programme';
			include "views/parcour/displayCell.php";
		}
	}
	
	public function displayFichiers($bouton=true)
	{
		$pos = 0;
		foreach ( $this->fichiers as $fichier ) {
			$pos++;
			$Model['entity']  = $fichier;
			$Model['pos']     = $pos;
			$Model['boutons'] = true;
			$Model['edit']    = $bouton;
			include "views/fichier/displayElmt.php";
		}
	}

	public function afficheParticipants($attente=0,$ventile=false,$hasBotton=false)
	{
		$cpt = 1;	
		$bgcolor = false;
		$liste = array();
		if ( $attente == 0 ) $liste = $this->participants;
		else $liste = $this->attentes;
		foreach ( $liste as $participant ) {
			$Model['entityRel'] = $participant;
			if ( $participant->id_membre   != null ) $Model['entity'] = $participant->id_membre;
			if ( $participant->id_personne != null ) $Model['entity'] = $participant->id_personne;
			$Model['boutons']   = $hasBotton;
			$Model['pos']       = $cpt++;
			$Model['ventile']   = $ventile;
			$Model['attente']   = $attente;
			$Model['classe']    = '';
			if ($bgcolor) $Model['classe'] = 'class="tabLigneBg"';
			$bgcolor = !$bgcolor;
			include "views/participant/displayCell.php";
		}
	}

	public function afficheParticipantsAttente($hasBotton=false)
	{
		$cpt = 1;
		$bgcolor = false;
		foreach ( $this->attentes as $participant ) {
			$Model['entityRel'] = $participant;
			if ( $participant->id_membre   != null ) $Model['entity'] = $participant->id_membre;
			if ( $participant->id_personne != null ) $Model['entity'] = $participant->id_personne;
			$Model['boutons']   = $hasBotton;
			$Model['pos']       = $cpt++;
			$Model['classe']    = '';
			if ($bgcolor) $Model['classe'] = 'class="tabLigneBg"';
			$bgcolor = !$bgcolor;
			include "views/participant/displayCell.php";
		}
	}
/*
	public function afficheAnimateurs($hasBotton=false,$idParcour=null)
	{
		$cpt = 1;
		foreach ( $this->getAttribut('animateurs')->value as $anim ) {
			if ( $idParcour == null || $anim->ventile_anim == null || $anim->ventile_anim->id == $idParcour ) {
				$Model['entityRel'] = $anim->id_animateur;
				$Model['pos'] = $cpt++;
				$Model['boutons']   = $hasBotton;
				$Model['ventile']   = $idParcour;
				include "views/animateur/add.php";
			}
		}
	}
*/
	public function parcourAnimateurs($idparcour)
	{
		$animateurs = static::$COL_ANIMATEURS;
		$lst = $this->$animateurs;
		$str = "";
		foreach ( $lst as $animateur ) {
			if ( $animateur->ventile_anim == null || $animateur->ventile_anim->id == $idparcour ) {
				if ( empty($str) ) $str .= "<B><U>".strtoupper(substr($animateur->id_animateur->prenom,0,1)).". ".$animateur->id_animateur->nom."</U></B>";
				else $str .= ", ".strtoupper(substr($animateur->id_animateur->prenom,0,1)).". ".$animateur->id_animateur->nom;
			}
		}
		if ( empty($str) ) return "Aucun animateur accompagne cette randonnée.";
		else return $str;
	}

	public function isResponsable($idUser=null)
	{
		if ($idUser == null) $idUser = Security::getConnectedUser()->id;
		if ( $this->id_responsable->id == $idUser ) return true;
		if ( $this->id_inscription != null && $this->id_inscription->id == $idUser ) return true;
		foreach ( $this->animateurs as $animateur ) {
			if ( $animateur->id_animateur->id == $idUser ) return true;
		}
		return false;
	}
	
	public function isProprio() {
		if ( $this->synthese->valide == 1 ) return false;
		return $this->isResponsable();
	}

	public function isParticipant($idUser=null)
	{
		if ($idUser == null) $idUser = Security::getConnectedUser()->id;
		foreach ( $this->participants as $participants ) {
			if ( $participants->id_membre != null && $participants->id_membre->id == $idUser ) return true;
			if ( $participants->id_personne != null && $participants->id_personne->id == $idUser ) return true;
		}
		return false;
	}

	public static function filtreTypeRando( $lst , $id_typerando ) 
	{
		if ( !empty($id_typerando) ) {
			foreach ($lst as $prog) {
				if ( $prog->randonnee->typerando->id != $id_typerando ) unset($lst[$prog->id]);
			}
			
		}
		
		return $lst;
	}

}

?>
