<?php
namespace entities;

use lib\EntityRelation;
use entities\Membre;
use lib\attributs\Relation;
use lib\attributs\Entier;

class Programme_Animateur extends EntityRelation
{
	public static $COL_ID             = 'id_programme';
	public static $COL_ID_REL         = 'id_animateur';
	public static $COL_VENTILE_ANIM   = 'ventile_anim';
	public static $COL_POSITION       = 'position';
	protected static $NAME_ENTITY_REL = 'entities\\Membre';

	protected function initAttributs()
	{
		parent::initAttributs();
		$this->attributs[static::$COL_VENTILE_ANIM] = new Relation(static::$COL_VENTILE_ANIM, null, 'entities\\Parcour',null,true);
		$this->attributs[static::$COL_POSITION ]    = new Entier(static::$COL_POSITION,1);
	}
	
    public function __toString()
    {
		$animateur = static::$COL_ID_REL;
        return (string)$this->$animateur;
    }

	public static function displayListForm($idProgramme)
	{
		$filtre = "id IN (SELECT id_membre FROM gari_role_membre WHERE id_role = 2)";
		if ( !empty($idProgramme) ) $filtre .= "AND id NOT IN (SELECT id_animateur FROM gari_programme_animateur WHERE id_programme = ".$idProgramme.")";
		$lst = Membre::selectList($filtre);
		if ( !empty($idProgramme) ) $lstInit = static::selectList('id_programme = '.$idProgramme);
		else $lstInit = array();
		$nomAttribut = "animateurs";
        ob_start();
        include "lib/views/listMulti.php";
        return ob_get_clean();
	}
	
	public function isProprio() {
		if ( $this->{static::$COL_PROGRAMME}->synthese->valide == 1 ) return false;
		return $this->{static::$COL_PROGRAMME}->isProprio();
	}
	
}

?>
