<?php
namespace entities;

use lib\EntityRelation;
use entities\Programme;
use entities\Parcour;
use lib\attributs\Liste;

class Programme_Parcour extends EntityRelation
{
	public static $COL_ID             = 'id_programme';
	public static $COL_ID_REL         = 'id_parcour';
	protected static $NAME_ENTITY_REL = 'entities\\Parcour';
	private $animateurs;
	
    public function __toString()
    {
		$parcour = static::$COL_ID_REL;
        return (string)$this->$parcour;
    }

	public function __get($name)
	{
		switch ( $name )
    	{
    		case 'parcour' :
    			return $this->attributs[static::$COL_ID_REL]->value;
    			break;
    		case 'animateurs' :
				return $this->getAttribut('animateurs')->value;
    			break;

    		default:
    			return parent::__get($name);
    			break;
    	}
	}

	public function &getAttribut($name) 
	{
		if ( $name == 'animateurs' ) {
			if ( empty($this->animateurs) ) $this->animateurs = new Liste('animateurs',null, 'entities\\Programme_Animateur','id_programme','id_animateur','position',$this->id_programme,false,false,false,'ventile_anim='.$this->id_parcour->id);
			return $this->animateurs;
		}
		else {
			return parent::getAttribut($name);
		}
	}

	public static function displayListForm($inits=null,$pos=0,$id_rando=null)
	{
		$filtre = null;
		if ( !empty($id_rando) ) $filtre = "id_randonnee = $id_rando";
		$lst = Parcour::selectList($filtre);
		$str  = '<SELECT name="id_parcour_'.$pos.'">';
		foreach ( $lst as $parcour ) {
			$selected = "";
			if ( $inits != null ) {
				foreach ( $inits as $init ) 
					if ( $init->id == $parcour->id ) $selected = "SELECTED";
			}
			$str .= '	<OPTION value="'.$parcour->id.'" '.$selected.'> '.$parcour.' </OPTION>';
		}
		$str  .= '</SELECT>';
		return $str;
	}
	
	public function isProprio() {
		if ( $this->{static::$COL_PROGRAMME}->synthese->valide == 1 ) return false;
		return $this->{static::$COL_PROGRAMME}->isProprio();
	}

}

?>
