<?php
namespace entities;

use lib\Entity;
use lib\security\Security;
use lib\attributs\DateHeure;
use lib\attributs\Entier;
use lib\attributs\Choix;
use lib\attributs\Texte;
use lib\attributs\Relation;
use lib\attributs\Chaine;

class Programme_Synthese extends Entity
{
	public static $COL_ID             = 'id_synthese';
	public static $COL_REMARQUE       = 'remarques';
	public static $COL_ANOTER         = 'anoter';
	public static $COL_VALIDE         = 'valide';
	public static $COL_DATECREATION   = 'datecreation';
	public static $COL_CREATEUR       = 'id_createur';
	public static $COL_PROGRAMME      = 'id_programme';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_REMARQUE       => new Texte(static::$COL_REMARQUE,null,true),
			static::$COL_ANOTER         => new Texte(static::$COL_ANOTER,null,true),
			static::$COL_VALIDE         => new Choix(static::$COL_VALIDE,0,array( 0 => 'Non valide', 1 => 'Valide')),
			static::$COL_DATECREATION   => new DateHeure(static::$COL_DATECREATION,date("Y-m-d H:i:s"), false,false, true),
			static::$COL_CREATEUR       => new Relation(static::$COL_CREATEUR, Security::getConnectedUser() , 'entities\\Membre'),
			static::$COL_PROGRAMME      => new Relation(static::$COL_PROGRAMME, null, 'entities\\Programme'),
		);	
	}
	
    public function __toString()
    {
		$remarque = static::$COL_REMARQUE;
		return ( $this->$remarque != null ) ? $this->$remarque : 'Aucune remarque';
    }

	public function __get($name)
	{
		switch ( $name )
    	{
    		case 'createur' :
    			return $this->attributs[static::$COL_CREATEUR]->value;
    			break;
    		case 'programme' :
    			return $this->attributs[static::$COL_PROGRAMME]->value;
    			break;
    		default:
    			return parent::__get($name);
    			break;
    	}
	}
	
}

?>
