<?php
namespace entities;

use entities\Programme;
use lib\Entity;
use lib\DBConnexion;
use lib\attributs\DateHeure;
use lib\attributs\Chaine;
use lib\attributs\Relation;
use lib\attributs\Liste;
use lib\attributs\Colonne;

class Randonnee extends Entity
{
	public static $COL_ID           = 'id';
	public static $COL_DEPARTEMENT  = 'departement';
	public static $COL_COMMUNE      = 'commune';
	public static $COL_LIEU         = 'lieu';
	public static $COL_DATECREATION = 'datecreation';
	public static $COL_CREATEUR     = 'id_createur';
	public static $COL_TYPERANDO    = 'id_typerando';
	public static $COL_PARCOURS     = 'parcours';
	public static $COL_RANDONNEES   = 'randonnees';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_DEPARTEMENT  => new Chaine(static::$COL_DEPARTEMENT),
			static::$COL_COMMUNE      => new Chaine(static::$COL_COMMUNE),
			static::$COL_LIEU         => new Chaine(static::$COL_LIEU),
			static::$COL_DATECREATION => new DateHeure(static::$COL_DATECREATION,date("Y-m-d H:i:s"), false,false, true),
			static::$COL_CREATEUR     => new Relation(static::$COL_CREATEUR, null, 'entities\\Membre'),
			static::$COL_TYPERANDO    => new Relation(static::$COL_TYPERANDO, 1, 'entities\\TypeRando'),
			static::$COL_PARCOURS     => new Liste(static::$COL_PARCOURS,null, 'entities\\Parcour','id_randonnee','nomParcour'),
			static::$COL_RANDONNEES   => new Liste(static::$COL_RANDONNEES,null, 'entities\\Programme','id_randonnee','datedepart DESC'),
		);	
	}
	
    public function __toString()
    {
    	$departement = static::$COL_DEPARTEMENT;
    	$commune     = static::$COL_COMMUNE;
    	$lieu        = static::$COL_LIEU;
		return $this->$lieu.', '.$this->$commune.' ('.$this->$departement.')';
    }

	public function __get($name)
	{
		switch ( $name )
    	{
    		case 'createur' :
    			return $this->attributs[static::$COL_CREATEUR]->value;
    			break;
    		case 'typerando' :
    			return $this->attributs[static::$COL_TYPERANDO]->value;
    			break;
    		case 'datelastrando' :
				$ret = Programme::selectMax('datedepart','id_randonnee = '.$this->id);
				if ( empty($ret) ) return '';
    			else return date ('d/m/Y', strtotime($ret));
    			break;
    		default:
    			return parent::__get($name);
    			break;
    	}
	}
	
	public static function displayList($pos=null,$init=0,$obligatoire=false)
	{
		$lst = static::selectList();
		if ( $pos != null ) $pos = '_'.$pos;
		else $pos = '';
		$str  = '<SELECT name="id_randonnee'.$pos.'">';
		if ( !$obligatoire ) $str .= '	<option value="">Sélectionnez une randonnée ...</option>';
		foreach ( $lst as $rando ) {
			$selected = "";
			if ( $init == $rando->id ) $selected = "SELECTED";
			$str .= '	<option value="'.$rando->id.'" '.$selected.'>'.(string)$rando.'</option>';
		}
		$str .= '</SELECT>';
		return $str;
	}
	
	public static function displayListDepartements($dpt=null)
	{
		global $dbcnx;
		$cnx = &$dbcnx;
		$classeName = get_called_class();
		$tableName = self::getStaticNomTable();
		$tabRet = array();
		$errmsg = " Select liste (Table ".$tableName.") : ";
		
		$query = "SELECT DISTINCT (".static::$COL_DEPARTEMENT.") AS ".static::$COL_DEPARTEMENT." FROM ".$tableName." ORDER BY ".static::$COL_DEPARTEMENT;

		$res = $cnx->select($query);
		foreach ( $res as $ligne ) {
			$tabRet[] = $ligne[static::$COL_DEPARTEMENT];
		}
		
		$str  = '<SELECT name="departement">';
		$str .= '	<option value="">Sélectionnez un département ...</option>';
		foreach ( $tabRet as $valeur ) {
			$selected = "";
			if ( strtoupper($dpt) == strtoupper($valeur) ) $selected = "SELECTED";
			$str .= '	<option value="'.$valeur.'" '.$selected.'>'.$valeur.'</option>';
		}
		$str .= '</SELECT>';
		return $str;
	}
	
	public static function countParcours($lst)
	{
		$res = 0;
		foreach ( $lst as $entite ) $res += count($entite->parcours);
		return $res;
	}
	
	public function displayParcours()
	{
		foreach ( $this->parcours as $parcour ) {
			include "views/parcour/displayLight.php";
		}
	}
	
}

?>
