<?php
namespace entities;

use lib\Entity;
use lib\attributs\Choix;
use lib\attributs\Chaine;
use lib\attributs\DateHeure;
use lib\attributs\Relation;
use lib\attributs\Liste;

class Randonniere extends Entity
{
	public static $COL_ID            = 'id';
	public static $COL_TYPE          = 'type_event';
	public static $COL_DESCRIPTION   = 'description_event';
	public static $COL_DATE          = 'date_event';
	public static $COL_DATESTART     = 'datestart_event';
	public static $COL_DATEEND       = 'dateend_event';
	public static $COL_RESPONSABLE   = 'id_responsable';
	public static $COL_PERMANENCIERS = 'permanenciers';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_TYPE          => new Choix(static::$COL_TYPE,0,array( 0 => 'Permanence', 1 => 'Autre évènement')),
			static::$COL_DESCRIPTION   => new Chaine(static::$COL_DESCRIPTION,'Permanence'),
			static::$COL_DATE          => new DateHeure(static::$COL_DATE,null),
			static::$COL_DATESTART     => new DateHeure(static::$COL_DATESTART,null),
			static::$COL_DATEEND       => new DateHeure(static::$COL_DATEEND,null),
			static::$COL_RESPONSABLE   => new Relation(static::$COL_RESPONSABLE, null, 'entities\\Membre',null,true),
			static::$COL_PERMANENCIERS => new Liste(static::$COL_PERMANENCIERS, null, 'entities\\Permanencier','id_randonniere','id_membre','nom,prenom'),
		);	
	}
	
    public function __toString()
    {
    	$nom   = static::$COL_DESCRIPTION;
    	$type  = static::$COL_TYPE;
		$debut = $this->getAttribut(static::$COL_DATESTART)->heureMin;
		$fin   = $this->getAttribut(static::$COL_DATEEND)->heureMin;
		$date = $this->getAttribut(static::$COL_DATESTART)->annee.$this->getAttribut(static::$COL_DATESTART)->mois.$this->getAttribut(static::$COL_DATESTART)->jour;
		$eventtype='evenement';
		if ( $this->$type == 0 ) $eventtype='permanence';
		$title = $debut.' à '.$fin." : \n    ".$this->description_event;
		switch ( $this->$type )
		{
			case 0 :
				foreach( $this->permanenciers as $permanencier ) {
					$title .= "\n    - ".(string)$permanencier->id_membre;
					if ( $permanencier->type_permanencier == 1 ) $title .= ' (Animateur)';
				}
				break;
			case 1 :
				$title .= "\n    Responsable : ".(string)$this->id_responsable;
				break;
		}
		return '<li class="'.$eventtype.'"><A href="_Calendrier_display&id='.$this->id.'" title="'.$title.'">'.$debut.' à '.$fin.'</A></li>';
    }

	public function displayPermanenciers($boutons=false)
	{
		$pos = 0;
		foreach ( $this->permanenciers as $permanencier ) 
		{
			$Model['pos']           = $pos++;
			$Model['boutons']       = $boutons;
			$Model['entityRel']     = $permanencier;
			include "views/randonniere/cellPermanencier.php";
		}
		return "";
	}
	
	public static function displayEvents( $date )
	{
		$ret = "";
		$lst = static::selectList("DATE_FORMAT(date_event,'%Y-%m-%d') = '".$date->format('Y-m-d')."'",'date_event,datestart_event');
		$ret .= '<ul style="margin:0;padding:0;">';
		foreach( $lst as $event ) 
		{
			$ret .= (string)$event;
		}
		$ret .= "</ul>";
		return $ret;
	}
	
}

?>
