<?php
namespace entities;

use lib\Entity;
use lib\security\Security;
use lib\attributs\DateHeure;
use lib\attributs\Entier;
use lib\attributs\Choix;
use lib\attributs\Texte;
use lib\attributs\Relation;

class Reco_Synthese extends Entity
{
	public static $COL_ID                = 'id_synthese';
	public static $COL_REMARQUE          = 'remarques';
	public static $COL_VALIDE            = 'valide';
	public static $COL_REMBOURSEMENT     = 'remboursement';
	public static $COL_VEHICULE1         = 'vehicule1';
	public static $COL_VEHICULE2         = 'vehicule2';
	public static $COL_VEHICULE3         = 'vehicule3';
	public static $COL_VEHICULE4         = 'vehicule4';
	public static $COL_VEHICULE5         = 'vehicule5';
	public static $COL_VEHICULEFORMATION = 'vehiculeFormation';
	public static $COL_DATECREATION      = 'datecreation';
	public static $COL_CREATEUR          = 'id_createur';
	public static $COL_RECONNAISSANCE    = 'id_reconnaissance';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_REMARQUE          => new Texte(static::$COL_REMARQUE,null,true),
			static::$COL_VALIDE            => new Choix(static::$COL_VALIDE,0,array( 0 => 'Non valide', 1 => 'Valide')),
			static::$COL_REMBOURSEMENT     => new Entier(static::$COL_REMBOURSEMENT,0),
			static::$COL_VEHICULE1         => new Entier(static::$COL_VEHICULE1,0),
			static::$COL_VEHICULE2         => new Entier(static::$COL_VEHICULE2,0),
			static::$COL_VEHICULE3         => new Entier(static::$COL_VEHICULE3,0),
			static::$COL_VEHICULE4         => new Entier(static::$COL_VEHICULE4,0),
			static::$COL_VEHICULE5         => new Entier(static::$COL_VEHICULE5,0),
			static::$COL_VEHICULEFORMATION => new Entier(static::$COL_VEHICULEFORMATION,-1),
			static::$COL_DATECREATION      => new DateHeure(static::$COL_DATECREATION,date("Y-m-d H:i:s"), false,false, true),
			static::$COL_CREATEUR          => new Relation(static::$COL_CREATEUR, Security::getConnectedUser(), 'entities\\Membre'),
			static::$COL_RECONNAISSANCE    => new Relation(static::$COL_RECONNAISSANCE, null, 'entities\\Reconnaissance'),
		);	
	}
	
    public function __toString()
    {
    	$remarque = static::$COL_REMARQUE;
		return ( $this->$remarque != null ) ? $this->$remarque : 'Aucune remarque';
    }

	public function __get($name)
	{
		switch ( $name )
    	{
    		case 'createur' :
    			return $this->attributs[static::$COL_CREATEUR]->value;
    			break;
    		case 'reconnaissance' :
    			return $this->attributs[static::$COL_RECONNAISSANCE]->value;
    			break;
    		default:
    			return parent::__get($name);
    			break;
    	}
	}
	
}

?>
