<?php
namespace entities;

use lib\Entity;
use lib\attributs\Chaine;
use lib\attributs\Texte;

class Role extends Entity
{
	public static $COL_ID      = 'id';
	public static $COL_LIBELLE = 'libelle';
	public static $COL_CODE    = 'code';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_CODE    => new Chaine(static::$COL_CODE),
			static::$COL_LIBELLE => new Chaine(static::$COL_LIBELLE,null,true),
		);
	}
	
    public function __toString()
    {
		$libelle = static::$COL_LIBELLE;
        return (string)$this->$libelle;
    }

	public static function displayList($init=0,$obligatoire=false)
	{
		$lst = static::selectList();
		$str  = '<SELECT name="id_role">';
		if ( !$obligatoire ) $str .= '	<option value="">Sélectionnez un role ...</option>';
		foreach ( $lst as $role ) {
			$selected = "";
			if ( $init == $role->id ) $selected = "SELECTED";
			$str .= '	<option value="'.$role->id.'" '.$selected.'>'.$role->libelle.'</option>';
		}
		$str .= '</SELECT>';
		return $str;
	}
}

?>
