<?php
namespace entities;

use lib\Entity;
use lib\attributs\Chaine;
use lib\attributs\Texte;

class TypeAnimateur extends Entity
{
	public static $COL_ID          = 'id';
	public static $COL_CODE        = 'code';
	public static $COL_DESCRIPTION = 'description';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_CODE        => new Chaine(static::$COL_CODE),
			static::$COL_DESCRIPTION => new Texte(static::$COL_DESCRIPTION,null,true),
		);
	}
	
    public function __toString()
    {
		$code = static::$COL_CODE;
        return (string)$this->$code;
    }

	public static function displayList($init=0,$obligatoire=false)
	{
		$lst = static::selectList();
		$str  = '<SELECT name="id_typeanimateur">';
		if ( !$obligatoire ) $str .= '	<option value="" SELECTED>Sélectionnez un type de d\'animateur ...</option>';
		foreach ( $lst as $tanim ) {
			$selected = "";
			if ( $init == $tanim->id ) $selected = "SELECTED";
			$str .= '	<option value="'.$tanim->id.'" '.$selected.'>'.$tanim->code.'</option>';
		}
		$str .= '</SELECT>';
		return $str;
	}

}

?>
