<?php
namespace entities;

use lib\Entity;
use lib\attributs\Chaine;
use lib\attributs\Texte;

class TypeBrevet extends Entity
{
	public static $COL_ID          = 'id';
	public static $COL_LIBELLE     = 'libelle';
	public static $COL_DESCRIPTION = 'description';
	
	public function initAttributs() 
	{
		$this->attributs = array(
			static::$COL_LIBELLE     => new Chaine(static::$COL_LIBELLE),
			static::$COL_DESCRIPTION => new Texte(static::$COL_DESCRIPTION,null,true),
		);
	}
	
    public function __toString()
    {
		$libelle = static::$COL_LIBELLE;
        return (string)$this->$libelle;
    }

	public static function displayList($init=0,$obligatoire=false)
	{
		$lst = static::selectList();
		$str  = '<SELECT name="id_typebrevet[]">';
		if ( !$obligatoire ) $str .= '	<option value="">Sélectionnez un type de brevet ...</option>';
		foreach ( $lst as $tbrevet ) {
			$selected = "";
			if ( $init == $tbrevet->id ) $selected = "SELECTED";
			$str .= '	<option value="'.$tbrevet->id.'" '.$selected.'>'.$tbrevet->libelle.'</option>';
		}
		$str .= '</SELECT>';
		return $str;
	}

}

?>
