<?php
namespace lib;

use lib\Constantes;
use lib\security\Security;

class Courriel {
	
	private static $COMPTE_APPL    = 'lib_appli';		// Nom du compte d'envoi du message
	private static $COURRIEL_REPLY = 'mail_adherent';	// Courriel d'envoi du message
	public static  $FIC_TRACES     = 'web/fichiers/mails/Mailing.trc';
	
	private static function traceMailing ($userMail,$objet,$message_send,$header) 
	{
		$fichier = fopen(static::$FIC_TRACES, 'a+');
		$str = "Anonimous";
		if ( Security::isConnected() ) {
			$user = Security::getConnectedUser();
			$str = (string)$user." (".$user->id.")";
		}
		
		fputs($fichier, "=========================================================================\n");
		fputs($fichier, date("d/m/Y H:i:s")."\t -> ".$objet." BY ".$str."\n");
		fputs($fichier, "-------------------------------------------------------------------------\n");
		fputs($fichier, $userMail."\n");
		fputs($fichier, "-------------------------------------------------------------------------\n");
		fputs($fichier, $header."\n");
		fputs($fichier, "-------------------------------------------------------------------------\n");
		fputs($fichier, $message_send."\n");
		fputs($fichier, "=========================================================================\n");
		fclose($fichier);
	}

	/*
	 * Mailing liste
	 */
	public static function mailingList($lst,$objet,$message,$fichiers=null) 
	{
		if ( !empty($lst) ) {
			$bcc = '';
			foreach( $lst as $entity ) {
				if ( $entity->mail != null ) {
					if ( !empty($bcc) ) $bcc .= ',';
					$bcc .= $entity->mail;
				}
			}
			$bcc .= ','.Constantes::getParametre('mail_adherent')->valeur;
			$bcc .= ','.Constantes::getParametre('mail_president')->valeur;
			$msg_html = static::formatMessage($message);
			return static::sendMail( '' , $objet , $msg_html , $bcc , $fichiers );
		}
		return false;
	}
	
	private static function formatMessage($message)
	{
		return '
			<html>
				<head>
					<title>Courrier de Contact</title>
					<META HTTP-EQUIV="content-type" CONTENT="text/html; charset=utf-8" />
					<style type="text/css">
					<!--
						* {
							font-familly: Arial;
						}
						h2 {
							font-size: 20pt:
							font-weight:bold;
							margin:20px 0px;
						}
						h4 {
							font-size: 14pt:
							font-weight:bold;
							margin:10px 0px;
						}
						h5 {
							font-size: 14pt:
							font-weight:bold;
							margin:0px;padding:0px;
						}
						p, A {
							font-size: 10pt;
							margin:0px;padding:0px;
						}
						.signature {
							width: 500px;
							margin: 5px;
							padding: 5px;
						}
						HR {
							margin:5px 0px;padding:0px;
						}
					-->
					</style>
				</head>
				<body>
					' . $message . '
					<br>
					<DIV class="signature">
						<h5>'.strtoupper(Security::getConnectedUser()->nom).' '.Security::getConnectedUser()->prenom.'</h5>
						<hr />
						<p>Les Randonneurs Sanaryens</p>
						<p><a href="'.Constantes::getParametre('rando_site')->valeur.'">'.Constantes::getParametre('rando_site')->valeur.'</a></p>
						<p>'.Constantes::getParametre('rando_adresse')->valeur.'</p>
						<p>Tèl : '.Constantes::getParametre('rando_tel')->valeur.'</p>
					</DIV>
				</body>
			</html>
			';
	}

	/*
	 * Mail PREVISION AU COORDINATEUR : coordinateur@randonneurs-sanaryens.fr
	 */
	public static function newPrevisionMail($entity,$mode) 
	{
		$titre = 'Nouvelle programmation de randonnée';
		$objet = "$titre ...";
		switch( $mode ) {
			case 'prev' : 
				$titre = 'Nouvelle programmation de randonnée';
				$objet = "$titre ...";
				break;
			case 'synthese_rando' : 
				$titre = 'Nouvelle synthese de randonnée';
				$objet = "$titre ...";
				break;
			case 'valid_synthese_rando' : 
				$titre = 'Validation de la synthese de randonnée';
				$objet = "$titre ...";
				break;
			case 'reco' : 
				$titre = 'Nouvelle reconnaissance de randonnée';
				$objet = "$titre ...";
				break;
			case 'synthese_reco' : 
				$titre = 'Nouvelle synthese de reconnaissance';
				$objet = "$titre ...";
				break;
		}
		$destinataire = Constantes::getParametre('mail_rando')->valeur;
		$msg_html = '
			<html>
				<head>
					<title>Courrier de Contact</title>
					<META HTTP-EQUIV="content-type" CONTENT="text/html; charset=utf-8" />
					<style type="text/css">
					<!--
						p, A {
							font-familly: Arial;
							font-size: 14pt:
							font-weight:bold;
							margin:10px 0px;
						}
					-->
					</style>
				</head>
				<body>
					<P>Une '.$titre.' vient d’être créée à '.(string)$entity.'</P>
				</body>
			</html>
			';
		return static::sendMail( $destinataire , $objet , $msg_html , null , null );
	}
	
	/*
	 * Mail de Contact
	 */
/*
	public static function contactMail($flux,$objet,$message) 
	{
		$nom         = $flux["nom"];
		$email       = $flux["email"];		//===== FROM
		$phone       = $flux["phone"];
		$adresse     = "";
		if ( !empty( $flux["adresse1"] ) ) $adresse .= $flux["adresse1"] . '<br />';
		if ( !empty( $flux["adresse2"] ) ) $adresse .= $flux["adresse2"] . '<br />';
		if ( !empty( $flux["cp"] ) )       $adresse .= $flux["cp"] . ' ';
		if ( !empty( $flux["ville"] ) )    $adresse .= $flux["ville"];
		$message_txt = $flux["message"];	//===== MESSAGE
		$message_html  = '
			<html>
				<head>
					<title>Courrier de Contact</title>
					<META HTTP-EQUIV="content-type" CONTENT="text/html; charset=utf-8" />
				</head>
				<body>
					' . $message_txt . '
					<table>
						<tr><td style="text-align:right;">Nom : </td><td>' . $nom . '</td></tr>
						<tr><td style="text-align:right;">Couriel : </td><td>' . $email . '</td></tr>
						<tr><td style="text-align:right;">Telephone : </td><td>' . $phone . '</td></tr>
						<tr><td style="text-align:right;">Adresse : </td><td>' . $adresse . '</td></tr>
					</table>
				</body>
			</html>
			';
		return static::sendMail( '' , $objet , $msg_html , $cci );
	}
*/

	/*
	 * Mail Fin de période de renouvellement au GESTIONNAIRE : coordinateur@randonneurs-sanaryens.fr
	 */
	public static function finRenouvellementMail($nb) 
	{
		$objet = '[ATTENTION] Fin de période de renouvellement ...';
		$destinataire = Constantes::getParametre('mail_adherent')->valeur;
		$msg_html = '
			<html>
				<head>
					<title>'.$objet.'</title>
					<META HTTP-EQUIV="content-type" CONTENT="text/html; charset=utf-8" />
					<style type="text/css">
					<!--
						p, A {
							font-familly: Arial;
							font-size: 14pt:
							font-weight:bold;
							margin:10px 0px;
						}
					-->
					</style>
				</head>
				<body>
					Bonjour, la période de renouvellement des licences pour l\'année <u>'.Constantes::getParametre('date_anneeactu')->valeur.'</u> 
					est terminée : <br/>
					Les membres ont été sauvegardés, Les anciens membres archivés ont été supprimés de la base et Les adhérents qui n\'ont pas 
					renouvelés ont été archivés (statut ancien) : '.$nb.' membres archivés.<br/><br/>
					<em>Ceci est un message automatique de Service Technique - Randonneurs Sanaryens</em>
				</body>
			</html>
			';
		return static::sendMail( $destinataire , $objet , $msg_html , null , null );
	}
	
	/*
	 * Mail de confirmation d'activation du compte
	 */
	public static function confirmActivationCompte($user) 
	{
		$objet = "Gari 2 : Activation de votre compte ...";
		$srep = substr($_SERVER['REQUEST_URI'],0,strrpos($_SERVER['REQUEST_URI'],'/'));
		$url = 'http://'.$_SERVER['HTTP_HOST'].$srep.'_Utilisateur_activation_'.$user->id.'_'.$user->jetonModif;
		$message_html  = '
			<html>
				<head></head>
				<body>
					<p><b>Bonjour '.$user.'</b> Pour activez votre compte :</p>
					<p><a href="'.$url.'">'.$url.'</a></p>
				</body>
			</html>';
		return static::sendMail($user->mail, $objet, $message_html);
	}

	/*
	 * Mail de validation d'activaion du compte
	 */
	public static function activationCompte($user) 
	{
		$objet = "Gari 2 : Votre compte est actif ...";
		$srep = substr($_SERVER['REQUEST_URI'],0,strrpos($_SERVER['REQUEST_URI'],'/'));
		$url = 'http://'.$_SERVER['HTTP_HOST'].$srep.'?model=Utilisateur&action=connect';
		$message_html  = '
			<html>
				<head></head>
				<body>
					<p><b>Bonjour '.$user.'</b></p>
					<p>Votre compte est maintenant actif. Vous pouvez vous connecter en clicquant <p><a href="'.$url.'">ici</a> :</p>
				</body>
			</html>';
		return static::sendMail($user->mail, $objet, $message_html);
	}
	
	/*
	* Mail de confirmation de changement de mot de passe
	*/
	public static function confirmPasswordChangement($user) 
	{
		$objet = "Gari 2 : Demande de modification de mot de passe ...";
		$srep = substr($_SERVER['REQUEST_URI'],0,strrpos($_SERVER['REQUEST_URI'],'/'));
		$url = 'http://'.$_SERVER['HTTP_HOST'].$srep.'/_Security_changePwd_'.$user->id.'_jeton_'.$user->jeton;
		$message_html  = '
			<html>
				<head></head>
				<body>
					<p><b>Bonjour '.$user.'</b> Pour Changer votre mot de passe veuiller vous rendre à l\'URL suivante :</p>
					<p><a href="'.$url.'">'.$url.'</a></p>
				</body>
			</html>';
		return static::sendMail($user->mail, $objet, $message_html);
	}

	/*
	 * Mail de validation de changement de mot de passe
	 */
	public static function passwordChangement($user) 
	{
		$objet = "Gari 2 : Modification de mot de passe ...";
		$srep = substr($_SERVER['REQUEST_URI'],0,strrpos($_SERVER['REQUEST_URI'],'/'));
		$url = 'http://'.$_SERVER['HTTP_HOST'].$srep.'/_Security_connect';
		$message_html  = '
			<html>
				<head></head>
				<body>
					<p><b>Bonjour '.$user.'</b></p>
					<p>Votre Mot de passe a été modifié correctement. Vous pouvez vous connecter <p><a href="'.$url.'">ici</a> :</p>
					<p>Si vous n\'êtes pas à l\'origine de cette modificaion veuillez contacter l\'administrateur du site.</p>
				</body>
			</html>';
		return static::sendMail($user->mail, $objet, $message_html);
	}

	/*
	 * Mail de validation de changement du courriel de contact
	 */	
	public static function emailChangement($user,$OldCourriel) 
	{
		$objet = "Gari 2 : Modification du courriel de contact ...";
		$message_html  = '
			<html>
				<head></head>
				<body>
					<p><b>Bonjour '.$user.'</b></p>
					<p>Votre adresse Email de contact a été modifiée. </p>
					<p>Si vous n\'êtes pas à l\'origine de cette modificaion veuillez contacter l\'administrateur du site au moyen du formulaire de contact.</p>
					<p>Ancien courriel : '.$OldCourriel.'</p>
					<p>Nouveau courriel : '.$user->mail.'</p>
				</body>
			</html>';
		return static::sendMail($user->mail, $objet, $message_html);
	}
	
	private static function sendMail($userMail, $objet, $message, $bcc=null, $fichiers=null) 
	{
//		$userMail = '';
//		$bcc = 'patrice.cuissard@free.fr';
		
		$passage_ligne = "\n";
		if (!preg_match("#^[a-z0-9._-]+@(hotmail|live|msn).[a-z]{2,4}$#", $userMail)) {
			$passage_ligne = "\r\n";
		}
		$separateur = "-----=".md5(rand());
		
		$courrielFrom  = "\"".Constantes::getParametre(static::$COMPTE_APPL)->valeur." \"<".Constantes::getParametre(static::$COURRIEL_REPLY)->valeur.">";
		$courrielReply = $courrielFrom;
		if ( Security::getConnectedUser() != null ) {
			$courrielFrom = "\"".(string)Security::getConnectedUser()." \"<".Security::getConnectedUser()->mail.">";
			$courrielReply = $courrielFrom.",".$courrielReply;
			if ( $bcc != null ) $bcc .= ',';
			$bcc .= Security::getConnectedUser()->mail;
		}

		//===============
		// MESSAGE HEADER
		$header = "From: ".$courrielFrom.$passage_ligne;
		$header.= "Reply-to: ".$courrielReply.$passage_ligne;
		$header.= "MIME-Version: 1.0".$passage_ligne;
		$header .= "Date: ".date('r').$passage_ligne;
		$header.= "Content-Type: multipart/mixed;".$passage_ligne." boundary=\"$separateur\"".$passage_ligne;
		if ( $bcc != null ) $header .= "Bcc: ".$bcc.$passage_ligne;
		
		//========
		// MESSAGE
		$message_send = $passage_ligne;
		$message_send .= "--".$separateur.$passage_ligne;
		$message_send .= "Content-Type: text/html; charset=\"utf8\"".$passage_ligne;
		$message_send .= "Content-Transfer-Encoding: 8bit".$passage_ligne;
		$message_send .= $passage_ligne;
		$message_send .= $message.$passage_ligne;
		
		//================================
		// RATTACHEMENT DES PIEVES JOINTES
		if ( !empty($fichiers) ) 
		{
			foreach ( $fichiers as $fic ) 
			{
				if ( !empty($fic['name']) ) 
				{
					if ( $fic['error'] != 0 ) throw new Exception('Erreur de transfert du fichier : ERROR '.$fic['error']);
					//=====Lecture et mise en forme de la pièce jointe.
					$fichier   = fopen($fic['tmp_name'], "r");
					$attachement = fread($fichier, filesize($fic['tmp_name']));
					$attachement = chunk_split(base64_encode($attachement));
					fclose($fichier);
					$message_send .= $passage_ligne;
					$message_send .= "--".$separateur.$passage_ligne;
					$message_send .= "Content-Type: ".$fic['type']."; name=\"".$fic['name']."\"".$passage_ligne;
					$message_send .= "Content-Transfer-Encoding: base64".$passage_ligne;
					$message_send .= "Content-Disposition: attachment; filename=\"".$fic['name']."\"".$passage_ligne;
					$message_send .= $passage_ligne;
					$message_send .= $attachement.$passage_ligne;
					$message_send .= $passage_ligne;
				}
			}
		}
		
		$message_send .= "--".$separateur.$passage_ligne;
		//===============
		// ENVOI COURRIEL

		static::traceMailing ($userMail,$objet,$message_send,$header);
//		return true;
		return mail($userMail,$objet,$message_send,$header);
	}

}

?>