<?php
namespace lib;

use lib\Exception;
use lib\Navigation;
use lib\GoPrevException;
use lib\GoCnxException;
use lib\security\Security;

abstract class EntityController
{

	protected $cnx;
	protected static $SESS_USER = 'DYNAVEO_SECURITY';
	protected static $ENTITY = '';

	public static $SECURITY = array();
	protected static $PATH_VIEW         = 'lib/views/';
	protected static $PATH_VIEW_LAYOUT  = 'views/layout.php';
	protected static $PATH_VIEW_LIST    = 'lib/views/list.php';
	protected static $PATH_VIEW_DISPLAY = 'lib/views/display.php';
	protected static $PATH_VIEW_INSERT  = 'lib/views/form.php';
	protected static $PATH_VIEW_UPDATE  = 'lib/views/form.php';
	protected static $PATH_VIEW_DELETE  = 'lib/views/delete.php';
	
	public function __construct()
	{
		global $dbcnx;
		$this->cnx = &$dbcnx;
	}
	
	public function __destruct()
	{
		global $cnx;
		unset($cnx);
	}
	
	public function printAction($params=null)
	{
		if ( !isset($_GET['id']) ) throw new Exception ( 'ERR-PARAM-NOID' );
		$fichier = 'Facture_'.$_GET['id'].'.pdf';
		
		// GENERER LE DOCUMENT
		$content = $this->get_page(intval($_GET['id'])); 
		require_once('lib/html2pdf/html2pdf.class.php');
		$html2pdf = new \HTML2PDF('P','A4','fr');
		$html2pdf->WriteHTML($content);
		$html2pdf->Output($fichier);
		exit;
	}
	
	protected function getPrintView($id) {
		return array('views/default/displayPrint.php',null);
	}
	
	private function get_page($id) {
		ob_start( ) ;
		$tab = $this->getPrintView($id);
		$Model['entity'] = $tab[1];
		include $tab[0] ;
		return ob_get_clean( ) ;
	}
	
	public function callAction($action,$params=null) {
		$ret = null;
		$methodeAction = $action."Action";
		if ( !method_exists ( $this , $methodeAction ) ) throw new Exception("Cette action n'existe pas !");
		$entityObj = $this->getEntityObj();
		if ( isset(static::$SECURITY[$action]) ) {
			if ( !Security::isConnected() ) throw new GoCnxException ( 'ERR-USER-NOTCONNECTED' );
			if ( !Security::isHabilit(static::$SECURITY[$action],$entityObj) ) throw new Exception ( 'ERR-USER-NOTHABILIT' );
		}
		try {
			$params = null;
			if ( !empty($entityObj) ) $params = array('entity' => $entityObj);
			$ret = $this->$methodeAction($params);
		}
		catch (Exception $e) {

			throw $e;
		}
		return $ret;
	}

	protected function getEntityObj()
	{
		$classEntity = static::$ENTITY;
		if ( empty($classEntity) ) return null;
		$idName = $classEntity::$COL_ID;
		$entityObj = null;
		if ( !empty($_GET[$idName]) || !empty($_POST[$idName]) ) 
		{
			try {
				$idEntity = ( !empty($_GET[$idName]) ) ? $_GET[$idName] : $_POST[$idName];
				$entityObj = new $classEntity($idEntity);
			}
			catch (Exception $e) {
				$entityObj = null;
			}
			
		}
		return $entityObj;
	}
	
	public function listAction($params=null)
	{
		$entity = static::$ENTITY;
		$Model['titre_page']    = "Liste des éléments";
		$Model['corps_page']    = static::$PATH_VIEW_LIST;
		$Model['lstEntities']   = $entity::selectList();
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function displayAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception ( 'ERR-PARAM-NOID' );
		$entity = $params['entity'];
		$Model['titre_page']    = "Fiche de l'élément";
		$Model['corps_page']    = static::$PATH_VIEW_DISPLAY;
		$Model['entity']        = $entity;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function insertAction($params=null)
	{
		$entity = static::$ENTITY;
		if ( isset($_POST['validForm']) ) {
			// Validation d'un Formulaire
			$entity = new $entity($_POST);
			$entity->insert(true);
			throw new GoPrevException('MSG-QUERYINSERT');
		}
		// Affichage du formulaire
		$Model['titre_page']    = "Création d'un nouvel élément";
		$Model['corps_page']    = static::$PATH_VIEW_INSERT;
		$Model['entity']        = new $entity();
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function updateAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception ( 'ERR-PARAM-NOID' );
		$entity = $params['entity'];
		if ( isset($_POST['validForm']) ) {
			// Validation d'un Formulaire
			$entity->setAttributes($_POST);
			$entity->update(true);
			throw new GoPrevException('MSG-QUERYUPDATE');
		}
		// Affichage du formulaire
		$Model['titre_page']    = "Modification d'un élément";
		$Model['corps_page']    = static::$PATH_VIEW_UPDATE;
		$Model['entity']        = $entity;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function deleteAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception ( 'ERR-PARAM-NOID' );
		$entity = $params['entity'];
		if ( isset($_POST['validForm']) ) {
			// Validation d'un Formulaire
			$entity->delete(true);
			throw new GoPrevException('MSG-QUERYDELETE');
		}
		// Affichage du formulaire
		$Model['titre_page']    = "Suppression d'un élément";
		$Model['corps_page']    = static::$PATH_VIEW_DELETE;
		$Model['entity']        = $entity;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function downloadAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$fichier = $params['entity']->url;
		
		// Création des headers, pour indiquer au navigateur qu'il s'agit d'un fichier à télécharger
		header('Content-Transfer-Encoding: binary'); //Transfert en binaire (fichier)
		header('Content-Disposition: attachment; filename="'.$params['entity']->name.'"'); //Nom du fichier
		header('Content-Type: application/force-download');
		header('Content-Length: ' . $params['entity']->size ); //Taille du fichier
		
		//Envoi du fichier dont le chemin est passé en paramètre
		readfile($fichier);
		
		throw new Exception();
	}
	
}