<?php
namespace lib;

use lib\Entity;
use lib\DisplayEntity;
use lib\Parametres;
use lib\security\Security;
use lib\attributs\Key;
use lib\attributs\DateHeure;
use lib\attributs\File;
use lib\attributs\Chaine;
use lib\attributs\Texte;
use lib\attributs\Relation;

abstract class EntityFichier extends Entity
{
	public static $NAME_CTRLEUR     = 'Fichier';
	public static $COL_ID           = 'id_fichier';
	
	public static $COL_DATEUPLOAD   = 'dateupload';			// Date d'upload du fichier d'origine
	public static $COL_NOMFIC       = 'nomfichier';			// Nom du fichier physique (sur le serveur)
	public static $COL_DESCRIPTION  = 'descriptionfichier';	// Description du fichier
	public static $COL_REPERTOIRE   = 'repertoirefichier';	// Répertoire de stockage du fichier physique
	public static $COL_CREATEUR     = 'id_createur';		// Identifiant de l'utilisateur ayant uploadé le fichier

	public static $COL_UPLOADFILE   = 'uploadfile';
	public static $COL_NAME         = 'name';				// Nom du fichier d'origine
	public static $COL_MIME         = 'mime';				// Type du fichier d'origine
	public static $COL_SIZE         = 'size';				// Taille du fichier d'origine (en Octet)

	/*
	 * Variable statique $TYPE
	 * Types d'extenssions de fichiers authorisés (En minuscule)
	 */
	protected static $TYPES = array( 
			'doc' => true, 'docx' => true, 'xls' => true, 'xlsx' => true, 'pdf' => true, 
			'jpg' => true, 'jpeg' => true, 
			'trk' => true, 'gpx' => true, 'csv' => true, 'grm' => true, 'mif' => true, 'dxf' => true, 'txt' => true,  
		);
	
	/**
	 * __construct
	 * Initialise l'instance : 
	 *   - Si parametre null objet vierge
	 *   - Si parametre = int (id) initialise l'instance avec la BD
	 *   - Si parametre = array  initialise les atributs avec les valeurs du tableau
	 * @param $data=null : identifiant (int) ou tableau de valeurs (index = nom des colonnes)
	 */
	public function __construct($data=null)
	{
		$id = static::$COL_ID;
		$this->noAction();
		$this->initAttributs();
		
		$this->attributs[static::$COL_ID]          = new Key(static::$COL_ID);		
		$this->attributs[static::$COL_DATEUPLOAD]  = new DateHeure(static::$COL_DATEUPLOAD,date("Y-m-d H:i:s"), false,false, true);
		$this->attributs[static::$COL_NOMFIC]      = new Chaine(static::$COL_NOMFIC, $this->initNomFichier() );
		$this->attributs[static::$COL_DESCRIPTION] = new Texte(static::$COL_DESCRIPTION,null,true);
		$this->attributs[static::$COL_REPERTOIRE]  = new Chaine(static::$COL_REPERTOIRE, $this->initRepFichier() ,true);
		$this->attributs[static::$COL_CREATEUR]    = new Relation(static::$COL_CREATEUR,Security::getConnectedUser(),'entities\\Membre',null,true);
		$this->attributs[static::$COL_UPLOADFILE]  = new File(static::$COL_UPLOADFILE,null,array('name' => static::$COL_NAME, 'mime' => static::$COL_MIME, 'size' => static::$COL_SIZE));

		$this->$id = null;
		if ( $data != null ) {
			if ( is_array($data) ) {
				// On a passe un tableau avec des valeurs en parametres
				$this->setAttributes($data);
			}
			else {
				// On a passe un identifiant en parametre
				$this->$id = $data;
				$this->select();
			}
		}
	}
	
	public function initAttributs() 
	{
		$this->attributs = array();	
	}

	public function __toString()
	{
		$aff = '';
		$name = $this->name;
		if ( ! empty($name) )
		{
			switch ( $this->group ) {
				case 'image' :
					$aff .= '<IMG src="' . $this->url . '" alt="' . $this->name . '" />';
					break;
				default :
					$aff = $this->extension ;
					break;
			}
			$aff = '<A href="_' . static::$NAME_CTRLEUR . '_download&' . $this->idClause . '" title="Click pour télécharger">'.$aff.'</A>';
			$display  = '<H6 title="' . $this->name . ' : ' . $this->description . '">'.$this->name.'</H6>';
			$display .= '<UL class="BtnsIco">';
			$display .= DisplayEntity::displayBouton('bouton','',static::$NAME_CTRLEUR,'dropFichier','drop',$this->idClause,"Supprimer le fichier",null,null,$this);
			$display .= '</UL>';
			$aff = '<DIV class="fichier ligneTab">'.$display.$aff.'</DIV>';
		}
		return $aff;
	}

	public function __get($name)
	{
		$nameFic = static::$COL_NAME;		
		switch ( $name )
		{
			case 'createur' :
				return $this->attributs[static::$COL_CREATEUR]->value;
				break;
			case 'description' :
				return $this->attributs[static::$COL_DESCRIPTION]->value;
				break;
			case 'url' :
				return $this->getPathData() . '/' . $this->getNom();
				break;
			case 'name' :
				return $this->getAttribut(static::$COL_UPLOADFILE)->name ;
				break;
			case 'size' :
				return $this->getAttribut(static::$COL_UPLOADFILE)->size ;
				break;
			case 'mime' :
				return $this->getAttribut(static::$COL_UPLOADFILE)->mime ;
				break;
			case 'type' :
				return strtolower(substr( $this->mime, strrpos($this->mime,'/')+1 )) ;
				break;
			case 'group' :
				return strtolower(substr( $this->mime, 0, strrpos($this->mime,'/') )) ;
				break;
			case 'extension' :
				$repcol     = static::$COL_REPERTOIRE;
				return substr($this->name,strripos($this->name,'.')) ;
				break;
			case 'display' :
				return '<DIV>'.(string)$this.'</DIV>';
				break;
			case 'nom' :
				return $this->getNom() ;
				break;
			case 'path' :
				return $this->getPathData();
				break;
			case 'isFileEmpty' :
				return ( $this->getAttribut(static::$COL_UPLOADFILE)->value == null ) ? true : false;
				break;
			default:
				return parent::__get($name);
				break;
		}
	}

	public function __set($name,$value)
	{
		$nameFic = static::$COL_NAME;
		switch ( $name )
		{
			case 'name' :
				$fichier = $this->getAttribut(static::$COL_UPLOADFILE)->name = $value;
				$this->attributs[static::$COL_UPLOADFILE]->isUpdate();
				break;
			case 'size' :
				$fichier = $this->getAttribut(static::$COL_UPLOADFILE)->size = $value;
				$this->attributs[static::$COL_UPLOADFILE]->isUpdate();
				break;
			case 'mime' :
				$fichier = $this->getAttribut(static::$COL_UPLOADFILE)->mime = $value;
				$this->attributs[static::$COL_UPLOADFILE]->isUpdate();
				break;
			case 'nom' :
				if ( $this->id == null ) {
					$this->getAttribut(static::$COL_NOMFIC)->value = $value;
					$this->attributs[static::$COL_UPLOADFILE]->isUpdate();
				}
				break;
			default:
				return parent::__set($name,$value);
				break;
		}
	}

	public function isTypeOk($extension)
	{
		if ( isset (static::$TYPES[strtolower($extension)]) && static::$TYPES[strtolower($extension)] ) return true;
		else return false;
	}
	
	public abstract function initNomFichier();

	public function initRepFichier()
	{
		return null ;
	}

	protected function getNom()
	{
		return $this->getAttribut(static::$COL_NOMFIC)->value ;
	}

	protected function getPathData()
	{
		$repcol = static::$COL_REPERTOIRE;
		$rep = ( $this->$repcol != null ) ? '/'.$this->$repcol : '';
		return Parametres::get("pathFiles") . $rep;
	}

	// *******************************************
	// ** Gestion des Champs de type Fichier
	// *******************************************
	
	protected function copieFichier($fichier)
	{
		$fichierTmp = $this->getAttribut($fichier)->temp;
		if ( !empty($fichierTmp) ) {
			$fichierNew = $this->path .'/'. $this->nom;
			if ( file_exists( $fichierNew ) ) {
				$this->dropFichier($fichier);
			}
			if ( !file_exists( $this->path ) ) {
				mkdir($this->getPathData());
			}
			if ( !move_uploaded_file( $fichierTmp , $fichierNew ) ) {
				throw new Exception( 'ERR-FILE-UPLOADCOPY', array('FICHIERTEMP' => $fichierTmp, 'FICHIER' => $fichierNew));
			}
		}
	}
	
	protected function dropFichier($fichier)
	{
		$nomFichier = $this->getPathData() .'/'. $this->getNom();
		unlink ( $nomFichier );
	}

}

?>
