<?php
namespace lib;

use lib\security\Security;

class Navigation {

	public static  $SESSION_ENTRY      = 'DYNAVEO_NAVIGATION';
	public static  $TRACE_FILE         = 'data/traces/usersCnx.trc';
	private static $DEFAULT_CTRLR      = '';
	private static $DEFAULT_CNX_URL    = '_Security_connect';
	private static $DEFAULT_MODEL      = 'Default';
	private static $DEFAULT_ACTION     = 'accueil';
	private static $URL_IDENTIFICATION = '_Utilisateur_identification&currPage=identification';

	private $lastSearch;
	private $lastSort;
	private $tabFiltre;
	private $historiqueUrl;
	private $nextUrl;
	private $alertMessage;
		
	public function __construct() 
	{
		$this->lastSearch    = "";
		$this->lastSort      = null;
		$this->nextUrl       = null;
		$this->tabFiltre     = array();
		$this->historiqueUrl = array( static::getDefaultUrl() );
	}
	
	public static function getDefaultUrl() 
	{
		return '_'.static::$DEFAULT_MODEL.'_'.static::$DEFAULT_ACTION;
	}

	private function traceCnx($url) 
	{
		$fichier = fopen(static::$TRACE_FILE, 'a+');
		$ipCnx = date("d/m/Y H:i:s")."\t -> ".$_SERVER['REMOTE_ADDR']."\t -> " . $url . "\n";
		fputs($fichier, $ipCnx);
		fclose($fichier);
	}
	
	public function setLastSearch($lastSearch) 
	{
		$this->lastSearch = $lastSearch;
	}
	
	public function getLastSearch() 
	{
		return $this->lastSearch;
	}
	
	public function setNextUrl($url) 
	{
		$this->nextUrl = $url;
	}
	
	public function getNextUrl() 
	{
		$url = $this->nextUrl;
		$this->nextUrl = null;
		if ( empty($url) && Security::isConnected() ) {
			$url = "_Membre_display_".Security::getConnectedUser()->id;
			for ($cpt=2; $cpt <=8 ; $cpt++) {
				if ( Security::isHabilit($cpt) ) return null;
			}
		}
		return $url;
	}
	
	public function setLastSort($lastSort) 
	{
		$this->lastSort = $lastSort;
	}
	
	public function getLastSort() 
	{
		return $this->lastSort;
	}
	
	public function resetFiltre() 
	{
		$this->tabFiltre = array();
	}
	
	public function addFiltre($index,$filtre) 
	{
		$this->tabFiltre[$index] = $filtre;
	}
	
	public function getFiltre($index) 
	{
		if ( isset($this->tabFiltre[$index]) ) {
			$val = $this->tabFiltre[$index];
			unset($this->tabFiltre[$index]);
			return $val;
		}
		else return false;
	}
	
	public function setAlertMessage($alertMessage,$typeAlert=null) 
	{
		$this->alertMessage = array($typeAlert,$alertMessage);
	}
	
	public function getAlertMessage() 
	{
		return $this->alertMessage;
	}
	
	public function putUrl($url)
	{
		$this->traceCnx($url);
		$oldurl = end($this->historiqueUrl);
		if ( $oldurl != $url ) $this->historiqueUrl[] = $url;
		if ( count($this->historiqueUrl) > 10 ) {
			$url = reset($this->historiqueUrl);
			$key = key($this->historiqueUrl);
			unset($this->historiqueUrl[$key]);
		}
	}
	
	public function getUrl()
	{
		if ( count($this->historiqueUrl) == 0 ) $this->putUrl(static::getDefaultUrl());
		$url = end($this->historiqueUrl);
		$key = key($this->historiqueUrl);
		unset($this->historiqueUrl[$key]);
		return $url;
	}
	
	public static function &sessionNavigation() 
	{
		$classeName = get_called_class();
		if ( !isset($_SESSION) ) session_start();
		if ( !isset($_SESSION[static::$SESSION_ENTRY] ) )  {
			$nav = new $classeName();
			$nav->putUrl( $nav->getDefaultUrl() );
			$_SESSION[static::$SESSION_ENTRY] = $nav;
			
		}
		return $_SESSION[static::$SESSION_ENTRY];
	}
	
	public static function unsetNavigation() 
	{
		if ( !isset($_SESSION) ) session_start();
		if ( isset($_SESSION[static::$SESSION_ENTRY] ) )  unset($_SESSION[static::$SESSION_ENTRY]);
	}
	
	public static function alertMessage($message=null,$typeAlert=null) 
	{
		$navigation = static::sessionNavigation();
		$alertMessage = $navigation->getAlertMessage();
		if ( empty($alertMessage) ) $alertMessage = null;
		$navigation->setAlertMessage($message,$typeAlert);
		$_SESSION[static::$SESSION_ENTRY] = $navigation;
		return $alertMessage;
	}
	
	public static function displayAlertMessage() 
	{
		$tabMsg = static::alertMessage();
		$TYPE_MSG  = $tabMsg[0];
		$ALERT_MSG = $tabMsg[1];
		
		$STR_TITRE = '';
		$STR_BTNS  = '';
		if ( !empty($ALERT_MSG) ) {
			$stbtn1 = '<li class="retour">Poursuivre<br />vos achats</li>';
			$stbtn2 = '<li class="close" data-popupid="#ALERTMESSAGE">Fermer</li>';
			switch ( $TYPE_MSG ) {
				case 1 :		// Poursuivre les achats ou redirige vers la validation de la commande
					$stbtn2 = '<li class="close" onClick="popupClose(\'#ALERTMESSAGE\');">Aller au<br />panier</a>';
					$STR_BTNS = '<ul class="Boutons">' .$stbtn1. $stbtn2. '</ul>';
					$STR_TITRE = 'Confirmation !';
					break;
				default :
					$STR_BTNS = '<ul class="Boutons">' . $stbtn2 . '</ul>';
					$STR_TITRE = 'Alert !';
					break;
			}
		}
		
		return '<div id="ALERTMESSAGE" data-titre="' . $STR_TITRE . '">' . $ALERT_MSG . $STR_BTNS . '</div>' ;
	}
	
	public static function lastSearch() 
	{
		$navigation = static::sessionNavigation();
		return $navigation->getLastSearch();
	}

	public static function putCurrUrl($isAjaxCall=false) 
	{
		if ( !$isAjaxCall ) {
			$url = $_SERVER['REQUEST_URI'];
			$navigation = static::sessionNavigation();
			$navigation->putUrl($url);
		}
	}

	public static function putNextUrl($url) 
	{
		$navigation = static::sessionNavigation();
		$navigation->setNextUrl($url);
	}

	public static function callCurrUrl($message=null,$typeAlert=null) 
	{
		$navigation = static::sessionNavigation();
		$url = $navigation->getUrl();
		if ($message != null) static::alertMessage($message,$typeAlert);
		header("Location: ".$url);
	}

	public static function callPrevUrl($message=null,$typeAlert=null) 
	{
		$navigation = static::sessionNavigation();
		$url = $navigation->getUrl();
		$url = $navigation->getUrl();
		if ($message != null) static::alertMessage($message,$typeAlert);
		header("Location: ".$url);
	}

	public static function callCnxUrl($message=null,$typeAlert=null) 
	{
		if ($message != null) static::alertMessage($message,$typeAlert);
		header("Location: ".static::$DEFAULT_CNX_URL);
	}

	public static function callNextUrl($message=null,$typeAlert=null) 
	{
		$navigation = static::sessionNavigation();
		$url = $navigation->getNextUrl();
		$_SESSION[static::$SESSION_ENTRY] = $navigation;
		if ( empty($url) ) {
			$url = $navigation->getUrl();
			$url = $navigation->getUrl();
		}
		if ($message != null) static::alertMessage($message,$typeAlert);
		header("Location: ".$url);
	}

	public static function callIdentificationUrl($message=null,$typeAlert=null) 
	{
		$navigation = static::sessionNavigation();
		$navigation->setNextUrl($_SERVER['REQUEST_URI']);
		$_SESSION[static::$SESSION_ENTRY] = $navigation;
		$urlIdent = static::$DEFAULT_CTRLR.static::$URL_IDENTIFICATION;
		if ($message != null) static::alertMessage($message,$typeAlert);
		header("Location: ".$urlIdent);
	}

	public static function putFiltre($filtre,$url=null) 
	{
		if ($url == null) {
			$pos1 = strripos($_SERVER['REQUEST_URI'],'/');
			$pos2 = strpos($_SERVER['REQUEST_URI'],'&');
			if ( $pos2 != 0 ) $url = substr($_SERVER['REQUEST_URI'],$pos1+1,$pos2-$pos1);
			else $url = substr($_SERVER['REQUEST_URI'],$pos1+1);
		}
		$navigation = static::sessionNavigation();
		$navigation->addFiltre($url,$filtre);
	}

	public static function callFiltre() 
	{
		$pos1 = strripos($_SERVER['REQUEST_URI'],'/');
		$pos2 = strpos($_SERVER['REQUEST_URI'],'&');
		if ( $pos2 != 0 ) $url = substr($_SERVER['REQUEST_URI'],$pos1+1,$pos2-$pos1);
		else $url = substr($_SERVER['REQUEST_URI'],$pos1+1);
		$navigation = static::sessionNavigation();
		return $navigation->getFiltre($url);
	}

}

?>