<?php
namespace lib\attributs;

use lib\attributs\Attribut;

class Choix extends Attribut 
{
	
	protected $values;
	
	public function __construct($libelle,$value,$values,$nullable=false,$readonly=false,$disabled=false,$confirm=false) 
	{
		parent::__construct($libelle,$value,$nullable,$readonly,$disabled,$confirm);
		$this->values = $values;
	}

	public function __toString() {
		return $this->values[$this->value];
	}

	protected function setValue($value)
	{
		$this->value = $value;
	}

	public function queryValue()
	{
		if ( is_string($this->value) ) return "'".$this->value."'";
		else return $this->value;
	}
	
	public function displayForm() 
	{
		$str = '<SELECT name="'.$this->libelle.'">';
		foreach ( $this->values as $key => $choix )
		{
			$selected = "";
			if ( $key == $this->value ) $selected = "SELECTED";
			$str .= '<OPTION value="'.$key.'" '.$selected.'>'.$choix.'</OPTION>';
		}
		$str .= '</SELECT>';
		return $str;
	}

	public function querySetValue($attrName=null)
	{
		if ( isset($this->value) ) 
		{
			if ( empty($this->value) ) return $attrName." = 0";
			else return $attrName." = ".$this->queryValue();
		}
		elseif ( $this->nullable && !$this->readonly ) 
		{
			return $attrName."= NULL";
		}
		return null;
	}
	
}
