<?php
namespace lib\attributs;

use lib\DBConnexion;
use lib\Exception;
use lib\attributs\Attribut;

class File extends Attribut 
{
	
	protected $cols;

	public function __construct($libelle,$values=null,$cols=null,$nullable=false,$readonly=false,$disabled=false) 
	{
		if ( empty($values) ) $values = array('name' => null, 'mime' => null, 'size' => 0, 'temp' => null);
		parent::__construct($libelle,$values,$nullable,$readonly,$disabled);
		if ( empty($cols) ) $this->cols = array('name' => 'name', 'mime' => 'mime', 'size' => 'size');
		else $this->cols = $cols;
	}

	public function __get($name)
	{
		switch ($name) 
		{
			case 'name':
				return DBConnexion::SQLDecode($this->value['name']);
				break;
			case 'mime':
				return DBConnexion::SQLDecode($this->value['mime']);
				break;
			case 'size':
				return $this->value['size'];
				break;
			case 'temp':
				return DBConnexion::SQLDecode($this->value['temp']);
				break;
			case 'colname':
				return DBConnexion::SQLDecode($this->cols['name']);
				break;
			case 'colmime':
				return DBConnexion::SQLDecode($this->cols['mime']);
				break;
			case 'colsize':
				return DBConnexion::SQLDecode($this->cols['size']);
				break;
			case 'extension':
				return substr( $this->value['name'] , strripos( $this->value['name'] , '.' )+1 );
				break;
			default:
				return parent::__get($name);
				break;
		}
	}
	
	public function __set($name,$value)
	{
		switch ($name) 
		{
			case 'name':
				$this->value['name'] = DBConnexion::SQLEncode($value);
				$this->isUpdate();
				break;
			case 'mime':
				$this->value['mime'] = DBConnexion::SQLEncode($value);
				$this->isUpdate();
				break;
			case 'size':
				$this->value['size'] = DBConnexion::SQLEncode($value);
				$this->isUpdate();
				break;
			case 'temp':
				$this->value['temp'] = DBConnexion::SQLEncode($value);
				$this->isUpdate();
				break;
			case 'colname':
				$this->cols['name'] = DBConnexion::SQLEncode($value);
				break;
			case 'colmime':
				$this->cols['mime'] = DBConnexion::SQLEncode($value);
				break;
			case 'colsize':
				$this->cols['size'] = DBConnexion::SQLEncode($value);
				break;
			default:
				parent::__set($name, $value);
				break;
		}
	}
	
	public function __toString() {
		return $this->name;
	}
	
	protected function setValue($value)
	{
		if ( isset($value['error']) && $value['error'] > 0 ) {
			$errorMsg = "";
			switch ($value['error']){
				case 1: // UPLOAD_ERR_INI_SIZE
					throw new Exception('ERR-FILE-UPLOAD1');
					break;
				case 2: // UPLOAD_ERR_FORM_SIZE
					throw new Exception('ERR-FILE-UPLOAD2');
					break;
				case 3: // UPLOAD_ERR_PARTIAL
					throw new Exception('ERR-FILE-UPLOAD3');
					break;
				default: // UPLOAD_ERR_NO_FILE
					throw new Exception('ERR-FILE-UPLOAD4');
					break;
			}
		}
		else {
			if ( !isset($value['tmp_name']) ) $value['tmp_name'] = null;
			$this->value['name'] = DBConnexion::SQLEncode($value['name']);
			$this->value['mime'] = DBConnexion::SQLEncode($value['type']);
			$this->value['size'] = DBConnexion::SQLEncode($value['size']);
			$this->value['temp'] = ( !isset($value['tmp_name']) ) ? null : DBConnexion::SQLEncode($value['tmp_name']);
			$this->isUpdate();
		}
	}
	
	public function queryCol()
	{
		return $this->colname.",".$this->colmime.",".$this->colsize;
	}

	public function queryValue()
	{
		return "'".$this->name."','".$this->mime."',".$this->size;
	}
	
	public function querySetValue($attrName=null)
	{
		if ( $this->isUpdate ) 
		{
			if ( !empty($this->value['name']) && !empty($this->value['size']) )	return $this->colname." = '".$this->name."',".$this->colmime." = '".$this->mime."',".$this->colsize." = ".$this->size;
			else return $this->colname." = NULL,".$this->colmime." = NULL,".$this->colsize." = NULL";
		}
		return null;
	}
	
}
