<?php
namespace lib\attributs;

use lib\attributs\Attribut;

class Relation extends Attribut 
{

	protected $object;
	protected $order;
	
	public function __construct($libelle,$value,$object,$order=null,$nullable=false,$readonly=false,$disabled=false) 
	{
		parent::__construct($libelle,$value,$nullable,$readonly,$disabled);
		$this->object = $object;
		$this->order = $order;
	}

	public function __toString() {
		$className = $this->object;
		if ( empty($this->value) ) return '';
		else {
			$obj = new $className($this->value);
			return (string) $obj;
		}
	}

	protected function getValue()
	{
		if ( !empty($this->value) )
		{
			if ( is_int($this->value) ) 
			{
				$className = $this->object;
				return new $className($this->value);
			}
			if ( is_object($this->value) ) 
			{
				return $this->value;
			}
		}
		return null;
	}
	
	protected function setValue($value)
	{
		if ( is_object($value) ) $this->value = $value;
		else $this->value = intval($value);
	}
	
	public function queryValue()
	{
		if ( $this->getValue() == null ) return null;
		return $this->getValue()->id;
	}
	
	public function displayForm() 
	{
		$obj = $this->object;
		$lstObj = $obj::selectList(null,$this->order);
		$str = '<SELECT name="'.$this->libelle.'">';
		if ( $this->nullable ) $str .= '<OPTION value="" SELECTED>Null</OPTION>';
		foreach ( $lstObj as $id => $entite )
		{
			$selected = "";
			$valeur = $this->value;
			if ( !empty($valeur) != null && $id == $valeur ) $selected = "SELECTED";
			$str .= '<OPTION value="'.$id.'" '.$selected.'>'.$entite.'</OPTION>';
		}
		$str .= '</SELECT>';
		return $str;
	}
		
}
