<?php
	use lib\DisplayEntity;
	use entities\Randonniere;

	$aujourdhui = \DateTime::createFromFormat( 'd/m/Y' , date('d/m/Y') );
	$dateTime   = \DateTime::createFromFormat( 'dmY' , $Model['dateTime'] ) ;
	$dateprev = $dateTime->sub(new DateInterval('P7D'))->format('dmY');
	$datenext = $dateTime->add(new DateInterval('P14D'))->format('dmY');
	$dateTime->sub(new DateInterval('P7D'));
?>
	<STYLE type="text/css">
		.eventCalendar {
			width:980px;
			margin: 10px auto;
			position: relative;
		}
		.eventCalendar>DIV {
			width:100%;
			text-align: center;
		}
		.eventCalendar>.eventTitre {
			background-color : #224;
			font-size: 18pt;
			line-height:50px;
			color: #EEF;
		}
		.eventCalendar>DIV>DIV {
			display: table-cell;
			width:138px;
			border: solid 1px #000;
		}
		.eventCalendar>.eventEntete>DIV {
			height:30px;
			vertical-align: middle;
			text-align: center;
			background-color : #224;
			color: #EEF;
		}
		.eventCalendar>.eventCell>DIV {
			height:100px;
			text-decoration: none;
		}
		.eventCalendar>.eventCell>DIV:hover {
			background-color : #CCE;
			opacity: 0.7;
		}
		.eventCalendar>.eventCell>DIV>LABEL {
			display: block;
			width: 100%;
			line-height:30px;
			text-align: center;
			font-size: 12pt;
/*			background-color : #EEF; */
			color: #445;
		}
		.eventCalendar>.eventCell>DIV>SPAN {
			display: block;
			width: 100%;
			height:70px;
			vertical-align: middle;
			text-align: center;
			font-size: 11pt;
		}
		.eventCalendar>.eventCell>DIV>SPAN * {
			padding: 2px 5px;
			cursor: pointer;
			font-size: 8pt;
		}
		.enventBefore {
			background-color : #EEE;
		}
		.today {
			background-color : #CCE;
		}
		#navCalendar {
			width: 200px;
			margin : 10px auto;
		}
		#navCalendar>* {
			display: inline-block;
			padding: 3px;
			margin: 2px;
			text-align: center;
			text-decoration: none;
			border: solid 2px #444;
			border-radius: 5px;
		}
		#navCalendar .prev {
			width: 24px;
		}
		#navCalendar .next {
			width: 24px;
		}
		#navCalendar .now {
			width: 100px;
		}
		.evenement {
			display:block;
			margin:0;
			padding:0 0 0 5px;
			background-color: lightgreen;
		}
		.permanence {
			display:beck;
			margin:0;
			padding:0 0 0 5px;
			background-color: yellow;
		}
	</STYLE>
	
	<H1>Gestion de la Randonnière</H1>
			
	<ul class="Boutons" data-formname="formMembre">
		<?= DisplayEntity::displayBouton('retour','Retour') ?>
	</ul>
	
	<H2>Calendrier</H2>
	<DIV id="navCalendar">
		<A href="_Administration_planning&date=<?= $dateprev ?>" class="prev">&lt;</A>
		<A href="_Administration_planning" class="now">Aujourd'hui</A>
		<A href="_Administration_planning&date=<?= $datenext ?>" class="next">&gt;</A>
	</DIV>
	<DIV class="eventCalendar">
		<DIV class="eventEntete">
			<DIV>Lu.</DIV>
			<DIV>Ma.</DIV>
			<DIV>Me.</DIV>
			<DIV>Je.</DIV>
			<DIV>Ve.</DIV>
			<DIV>Sa.</DIV>
			<DIV>Di.</DIV>
		</DIV>
		
		<?php
			for ( $jourDelta = 0 ; $jourDelta < 35 ; $jourDelta++) 
			{
				$classe = '';
				if ( $dateTime < $aujourdhui ) {
					$classe = 'enventBefore';
				}
				elseif ( $dateTime == $aujourdhui ) {
					$classe = 'today';
				}
				else {
					$classe = 'enventAfter';
				}
				if ( $dateTime->format('w') == 1 ) 
				{
				?>
					<DIV class="eventCell">
				<?php
				}
			?>
				<DIV class="<?= $classe ?>">
					<LABEL>
						<UL class="BtnTitle">
							<LI class="ajaxOpen" data-url="_Calendrier_insert&date=<?= $dateTime->format('dmY') ?>" data-titre="Nouvel évènement" title="Ajouter un évènement"><?= $dateTime->format('d') ?> <?= $dateTime->format('M') ?></LI>
						</UL>
					</LABEL>
					<SPAN><?= Randonniere::displayEvents( $dateTime ) ?></SPAN>
				</DIV>
			<?php
				$dateTime->add(new DateInterval('P1D'));
				if ( $dateTime->format('w') == 1 ) 
				{
				?>
					</DIV>
				<?php
				}
			}
		?>
		<DIV id="eventDetail">
		</DIV>
	</DIV>
<?php
	$jourMois            = $dateTime->format('d');
	$année               = $dateTime->format('Y');
	$semaine             = $dateTime->format('W');
	$jourSemaine         = $dateTime->format('w');
	$jourSemaineStr      = $dateTime->format('l');
	$jourSemaineStrCourt = $dateTime->format('D');
	$mois                = $dateTime->format('m');
	$moisStr             = $dateTime->format('F');
	$moisStrCourt        = $dateTime->format('M');
	$bissextile          = $dateTime->format('L');
?>
