<?php
namespace lib\security;

use lib\Entity;
use lib\Exception;
use lib\GoCnxException;
use lib\Navigation;
use lib\security\Security;
use lib\Courriel;
use entities\Role;
use lib\attributs\Chaine;
use lib\attributs\Password;
use lib\attributs\DateHeure;
use lib\attributs\Mail;
use lib\attributs\Key;

class User extends Entity
{
	public    static $COL_ID               = 'id';
	public    static $COL_LOGIN            = 'login';
	public    static $COL_MOTDEPASSE       = 'motdepasse';
	public    static $COL_MAIL             = 'mail';
	public    static $COL_JETON            = 'jeton';
	public    static $COL_JETONVALID       = 'jetonValide';
	public    static $COL_VALIDE           = 'valide';
	public    static $COL_DATECREATION     = 'datecreation';
	
	protected static $VALIDITE_JETON       = 1;             // durée de validité du jeton en jours.
	
	public function initAttributs() 
	{
		$this->attributs = array();
	}
	
	/**
	 * __construct
	 * Initialise l'instance : 
	 *   - Si parametre null objet vierge
	 *   - Si parametre = int (id) initialise l'instance avec la BD
	 *   - Si parametre = array  initialise les atributs avec les valeurs du tableau
	 * @param $data=null : identifiant (int) ou tableau de valeurs (index = nom des colonnes)
	 */
	public function __construct($data=null)
	{
		$id = static::$COL_ID;
		$this->noAction();
		$this->initAttributs();
		
		$this->attributs[static::$COL_LOGIN]        = new Chaine(static::$COL_LOGIN);
		$this->attributs[static::$COL_MOTDEPASSE]   = new Password(static::$COL_MOTDEPASSE);
		$this->attributs[static::$COL_MAIL]         = new Mail(static::$COL_MAIL,null,true);
		$this->attributs[static::$COL_JETON]        = new Chaine(static::$COL_JETON,null,true);
		$this->attributs[static::$COL_JETONVALID]   = new Chaine(static::$COL_JETONVALID,null,true);
		$this->attributs[static::$COL_VALIDE]       = new DateHeure(static::$COL_VALIDE,null, true);
		$this->attributs[static::$COL_DATECREATION] = new DateHeure(static::$COL_DATECREATION,date("Y-m-d H:i:s"));
		$this->attributs[static::$COL_ID]           = new Key(static::$COL_ID);
		
		$this->$id = null;
		if ( $data != null ) {
			if ( is_array($data) ) {
				// On a passe un tableau avec des valeurs en parametres
				$this->setAttributes($data);
			}
			else {
				// On a passe un identifiant en parametre
				$this->$id = $data;
				$this->select();
			}
		}
	}
	
	public function updatePassword($flux) {
		$secByDay = 60*60*24;
		$jetonTest = addslashes( $flux[static::$COL_JETON] );
		$password  = addslashes( $flux[static::$COL_MOTDEPASSE] );
		$password_confirm = addslashes( $flux[static::$COL_MOTDEPASSE.'Confirm'] );
		$jeton     = $this->attributs[static::$COL_JETON]['value'];
		$datejeton = $this->attributs[static::$COL_JETONVALID]['value'];
		$nbJoursJeton = (strtotime(date("Y-m-d h:i:s")) - strtotime($datejeton)) / $secByDay;

		if ( $jeton == null ) 	                    throw new Exception ( "Erreur Changement de Mot de passe :<br /> Aucun jeton actif !" );
		if ( $jeton !=  $jetonTest )                throw new Exception ( "Erreur Changement de Mot de passe :<br /> Le Jeton de changement de mot de passe ne correspond pas ! !" );
		if ( $nbJoursJeton < static::$VALIDITE_JETON ) throw new Exception ( "Erreur Changement de Mot de passe :<br /> La durée de validité du Jeton est dépassée !" );
		if ( $password != $password_confirm )       throw new Exception ( "Erreur initialisation : La confirmation du mot de passe n'est pas valide" );

		$password = Security::cryptePwd($password);
		$this->updateLight(static::$COL_MOTDEPASSE." = '".$password."', ".static::$COL_JETON." = NULL, ".static::$COL_JETONVALID." = NULL");
	}
	
	public function activeUser($jetonTest) {
		$secByDay  = 60*60*24;
		$jeton     = $this->attributs[static::$COL_JETON]['value'];
		$datejeton = $this->attributs[static::$COL_JETONVALID]['value'];
		$nbJoursJeton = (strtotime(date("Y-m-d h:i:s")) - strtotime($datejeton)) / $secByDay;
		
		if ( $jeton == null ) 	                    throw new Exception ( "Erreur Activation :<br /> Aucun jeton actif !" );
		if ( $jeton !=  $jetonTest )                throw new Exception ( "Erreur Activation :<br /> Le Jeton d\'activation ne correspond pas ! !" );
		if ( $nbJoursJeton < static::$VALIDITE_JETON ) throw new Exception ( "Erreur Activation :<br /> La durée de validité du Jeton est dépassée !" );

		$this->updateLight(static::$COL_VALIDE." = 1, ".static::$COL_JETON." = NULL, ".static::$COL_JETONVALID." = NULL");
	}
	
	public function demandeActivation() {
		$this->demandeJeton();
		Courriel::confirmActivationCompte($this);
	}
	
	public function demandeChangementPassword() {
		$this->demandeJeton();
		Courriel::confirmPasswordChangement($this);
	}
	
	public function ChangementPassword($pwd,$pwdConfirm) {
		$this->updatePwd($pwd,$pwdConfirm);
		if ( ! Security::isConnected() ) {
			Courriel::passwordChangement($this);
			throw new GoCnxException('MSG-QUERYPWDUPDATE');
		}
	}
	
	private function demandeJeton()
	{
		$date = \DateTime::createFromFormat( 'Y-m-d H:i:s' , date('Y-m-d H:i:s') );
		$date->add(new \DateInterval('P'.static::$VALIDITE_JETON.'D'));
		
		$this->{static::$COL_JETONVALID} = $date->format('Y-m-d H:i:s');
		$this->{static::$COL_JETON} = uniqid ("lpc_",true);
		$this->update();
	}
	
	public function isJetonValid() {
		$date = \DateTime::createFromFormat( 'Y-m-d H:i:s' , date('Y-m-d H:i:s') );
		$dateJeton = \DateTime::createFromFormat( 'Y-m-d H:i:s' ,$this->{static::$COL_JETONVALID});
		if ( $date > $dateJeton ) return false;
		else return true;
	}
	
	public function updateDateConnexion() 
	{
		$datesysteme = date("Y-m-d h:i:s");
		$this->updateLight(static::$COL_DATECONNEXION." = '".$datesysteme."'");
	}
	
	public function isProprio() {
		return Security::isProprio($this->id);
	}
	
	public static function courrielExist($courriel) 
	{
		$lst = static::selectList(static::$COL_MAIL." = '".$courriel."'");
		if ( count($lst) == 1 ) return true;
		else return false;
	}
	
	public function getPtsFidele() {
		return Security::isProprio($this->id);
	}
		
	/**
	 * updatePwd
	 * Mise � jour d'une colonne password d'un enregistrement de la BD
	 * @param $isTransaction=false : booleen indique si l'insertion fait partie d'une Transaction/
	 * @throws Exception
	 */
	protected function updatePwd($pwd,$pwdConfirm) 
	{
		$errmsg = " UpdatePwd (Table ".$this->getTableName().") : ";
		$idvalue = $this->{static::$COL_ID};
		if ( $pwd != $pwdConfirm ) throw new Exception ( 'ERR-PASSWORD-NOTCONFIRMED' );
		if ( empty($idvalue) )     throw new Exception( 'ERR-QUERY-NOID',array('CIBLE' => $errmsg) );
		$this->{static::$COL_MOTDEPASSE} = $pwd;
		$this->{static::$COL_JETON}      = null;
		$this->{static::$COL_JETONVALID} = null;
		$this->update();
	}

}

?>
