<?php
use lib\security\Security;
$lstEntities = $Model['lstEntities'];
$sensOrdreT = "ASC";
$sensOrdreC = "ASC";
$sensOrdreO = "ASC";

?>

<H1>Liste des Fichiers</H1>

<?php include "views/filtres.php" ?>

<form method="POST" id="formLst" action="index.php?page=ligneLst" autocomplete="off">

	<input type="hidden" id="orderBy" name="orderBy" value="">
	<input type="hidden" id="orderType" name="orderType" value="">
    
    <table>
    
        <tr>
            <th width="25%"><a class="<?= $sensOrdreT ?>" href="_Fichier_list&order=titre&sens=<?= $sensOrdreT ?>">titre</a></th>
            <th width="20%"><a class="<?= $sensOrdreC ?>" href="_Fichier_list&order=categorie&sens=<?= $sensOrdreC ?>">Categorie</a></th>
            <th width="20%"><a class="<?= $sensOrdreO ?>" href="_Fichier_list&order=role&sens=<?= $sensOrdreO ?>">Role</a></th>
            <th width="7%">Derniere version</th>
            <th width="8%">Options</th>
        </tr>
        
<?php 
	foreach ( $lstEntities as $fichier ) 
	{ 
		if ( $fichier->isInPeriod($Model['filtres']['filterByDateDeb'],$Model['filtres']['filterByDateFin'])
				&& ( Security::isAdmin() || Security::isProprio( $fichier->role->id ) ) )
		{
?>
        <tr>
            <td>
                <a href="_Fichier_display&id=<?= $fichier->id ?>">
                    <?= $fichier->titre ?>
                </a>
            </td>
            <td><?= $fichier->categorie ?></td>
            <td><?= $fichier->role ?></td>
            <td><?= $fichier->version ?></td>
            <td>
				<ul class="IconesBoutons">
					<li id="download">
						<a href="_Version_download&id=<?= $fichier->last->id ?>">
							<img src="web/images/small-btn-download.png" class="icone" alt="Download" title="Télécharger le fichier">
						</a>
					</li>
				<?php 
				if ( Security::isAdmin() || Security::isWriter( $fichier->role->id ) )
				{
				?>
					<li id="update" onClick="requestAjax('_Version_insert&fichier=<?= $fichier->id ?>','#popup',popupData,null,'Nouvelle version du fichier');">
	                    <img src="web/images/small-btn-refresh.png" class="icone" alt="New" title="Nouvelle version du fichier">
					</li>
					<li id="delete" onClick="requestAjax('_Fichier_delete&id=<?= $fichier->id ?>','#popup',popupData,null,'Supprimer le fichier');">
	                    <img src="web/images/small-btn-trash.png" class="icone" alt="Delete" title="Supprimer le fichier">
					</li>				
				<?php 
				}
				?>
				</ul>
            </td>
        </tr>
<?php 
		}
	}  
?>
        
    </table>

	<?php //require("partiels/listeNavigation.php"); ?>

</form>

<br />
<ul class="Boutons">
	<li id="insert" onClick="requestAjax('_Fichier_insert','#popup',popupData,null,'Ajouter un nouveau fichier');">
		Ajouter
	</li>
</ul>
