<?php
	use lib\DisplayEntity;
	use lib\security\Security;
	use entities\Licence;
	use entities\TypeAnimateur;
	use entities\Etat;
	use entities\Role_Membre;
	
	$membre = $Model['entity'];
?>

<H1>Fiche Adhérent</H1>
		
<ul class="Boutons" data-formname="formMembre">
	<?= DisplayEntity::displayBouton('retour','Retour') ?>
	<?php
		if ( $membre->notActif() ) {
			echo DisplayEntity::displayBouton('bouton','Renouveler','Cheque','renouveler','valid','id_membre='.$membre->id,"Renouveler la personne");
		}
	?>
	<?= DisplayEntity::displayBouton('bouton','Modifier','Membre','update','edit','id='.$membre->id,"Modifier la personne",null,null,$membre) ?>
	<?php
		if ( $membre->notArchive() ) {
			echo DisplayEntity::displayBouton('bouton','Archiver','Membre','archive','archive','id='.$membre->id,"Archiver la personne");
		}
	?>
	<?= DisplayEntity::displayBouton('bouton','Supprimer','Membre','delete','delete','id='.$membre->id,"Supprimer la personne") ?>
	<?= DisplayEntity::displayBouton('bouton','Statistiques','Statistique','statUser','delete',$membre->idClause,"Statistiques de la personne",null,null,$membre) ?>
</ul>

<DIV class="table">

	<H2>Informations personnelles</H2>
	
	<DIV>
		<LABEL>Identifiant de connexion : </LABEL>
		<SPAN><?= $membre->login ?></SPAN>
	</DIV>
	
	<?php
	if ( $membre->isProprio() || Security::isAdmin() || Security::isGestionnaire() ) 
	{
	?>
	
	<DIV>
		<LABEL>Mot de passe : </LABEL>
		<SPAN id="password">
			<UL class="tinyBoutons">
				<?= DisplayEntity::displayBouton('ajaxOpen','Modifier','Security','changePwd','edit','id='.$membre->id,"Modification du mot de passe",null,null,$membre) ?>
			</UL>
		</SPAN>
	</DIV>
	
	<?php
	}
	?>
	
	<DIV>
		<LABEL>Numéro de licence : </LABEL>
		<SPAN><?= $membre->licence ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Type de licence : </LABEL>
		<SPAN>
			<?= $membre->id_licence ?>
		</SPAN>
	</DIV>
	<DIV>
		<LABEL>Date d'attribution de la licence : </LABEL>
		<SPAN><?= $membre->getAttribut('datelicence')->date ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Type d'animateur : </LABEL>
		<SPAN>
			<?= $membre->id_typeanimateur ?>
		</SPAN>
	</DIV>
	<DIV>
		<LABEL>
			Brevets : 	
		</LABEL>
		<SPAN id="brevets">
			<?= $membre->getAttribut('brevets')->affiche() ?> 
		</SPAN>
	</DIV>
	<DIV>
		<LABEL>
			Certificats : 	
		</LABEL>
		<SPAN id="certifs">
			<?= $membre->getAttribut('certifs')->affiche() ?> 
		</SPAN>
	</DIV>
	<DIV>
		<LABEL>Autre club : </LABEL>
		<SPAN><?= $membre->autreclub ?></SPAN>
	</DIV>

	<H2>Etat civil</H2>

	<DIV>
		<LABEL>Sexe : </LABEL>
		<SPAN><?= $membre->getAttribut('sexe') ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Nom : </LABEL>
		<SPAN><?= $membre->nom ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Prenom : </LABEL>
		<SPAN><?= $membre->prenom ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Nom de jeune fille : </LABEL>
		<SPAN><?= $membre->nomjeunefille ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Date de naissance : </LABEL>
		<SPAN><?= $membre->getAttribut('datenaissance')->date ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Lieu de naissance : </LABEL>
		<SPAN><?= $membre->lieunaissance ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Photo : </LABEL>
		<SPAN id="photos" data-pos="<?= count($membre->photos)+1 ?>">
			<?=  $membre->displayFichiers() ?>
		</SPAN>
	</DIV>

	<H2>Coordonnées de contact</H2>

	<DIV>
		<LABEL>Courriel : </LABEL>
		<SPAN><?= $membre->mail ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Téléphone : </LABEL>
		<SPAN><?= $membre->telephone ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Portable : </LABEL>
		<SPAN><?= $membre->portable ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>
			Adresses : 	
		</LABEL>
		<SPAN id="adresses">
			<?= $membre->getAttribut('adresses')->affiche() ?> 
		</SPAN>
	</DIV>
	<DIV>
		<LABEL>
			Personnes à contacter : 
		</LABEL>
		<SPAN id="contacts">
			<?= $membre->getAttribut('contacts')->affiche() ?> 
		</SPAN>
	</DIV>

	<H2>Informations complémentaires</H2>

	<DIV>
		<LABEL>Actif : </LABEL>
		<SPAN><?= $membre->getAttribut('actif') ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Activité actuelle : </LABEL>
		<SPAN><?= $membre->activiteactu ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Activité antérieure : </LABEL>
		<SPAN><?= $membre->activiteante ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>
			Etat : 	
		</LABEL>
		<SPAN>
			<?= $membre->id_etat ?>
		</SPAN>
	</DIV>
	<DIV>
		<LABEL>Rôles : </LABEL>
		<SPAN id="roles">
			<?= $membre->getAttribut('roles')->affiche() ?> 
		</SPAN>
	</DIV>
	<DIV>
		<LABEL>Paiements : </LABEL>
		<SPAN id="cheques">
			<?= $membre->getAttribut('cheques')->affiche() ?> 
		</SPAN>
	</DIV>
	<DIV>
		<LABEL>Note : </LABEL>
		<SPAN><?= $membre->note ?></SPAN>
	</DIV>
	<DIV>
		<LABEL>Commentaire : </LABEL>
		<SPAN><?= $membre->commentaire ?></SPAN>
	</DIV>
	
</DIV>	
