<?php
	use entities\Randonniere;
	use entities\Membre;
	$randonniere = $Model['entity'];
	$date = Datetime::createFromFormat('d/m/Y', $randonniere->getAttribut('date_event')->date );
	$action = 'insert';
	if ( $randonniere->id != null ) $action = 'update';
?>

<SCRIPT type="text/javascript">
$(document).ready( function() {
	$('#type_event').change(function(){
		var type = $(this).find("option:selected").val();
		var action = $(this).data('action');
		var date = $(this).data('date');
		document.location.href="_Calendrier_"+action+"&type_event="+type+"&date="+date ;
	});
});
</SCRIPT>
		
<DIV class="table">
	
	<FORM id="formAddPermanence" name="formAddPermanence" class="form" action="_Calendrier_<?= $action ?>" method="POST" autocomplete="off" enctype="multipart/form-data">
		
		<H2>Réservation pour la date du <?= $randonniere->getAttribut('date_event')->date ?></H2>
		
		<DIV>
			<LABEL>Type d'évènement : </LABEL>
			<SPAN>
				<SELECT id="type_event" name="type_event" data-action="<?= $action ?>" data-date="<?= $date->format('dmY') ?>" >
					<OPTION value="0" <?= ( $randonniere->type_event == 0 ) ? 'SELECTED' : '' ?> >Permanence</OPTION>
					<OPTION value="1" <?= ( $randonniere->type_event == 1 ) ? 'SELECTED' : '' ?> >Autre</OPTION>
				</SELECT>
			</SPAN>
		</DIV>
		<DIV>
			<LABEL>Heure de début : </LABEL>
			<SPAN><input type="text" class="time" id="datestart_event" name="datestart_event" placeholder="hh:mm" value="<?= $randonniere->getAttribut('datestart_event')->heureMin ?>" REQUIRED /></SPAN>
		</DIV>
		<DIV>
			<LABEL>Heure de fin : </LABEL>
			<SPAN><input type="text" class="time" id="dateend_event" name="dateend_event" placeholder="hh:mm" value="<?= $randonniere->getAttribut('dateend_event')->heureMin ?>" REQUIRED /></SPAN>
		</DIV>
		<DIV>
			<LABEL>Descripton : </LABEL>
			<SPAN><input type="text" list="listTypeEvents" id="description_event" name="description_event" value="<?= $randonniere->description_event ?>" REQUIRED /></SPAN>
		</DIV>
		
		<?php
			if ( $randonniere->type_event == 0 )
			{
		?>
			<DIV>
				<LABEL>
					Personnes de Permanence : 
				</LABEL>
				<SPAN id="formaddpermanencier" name="formaddpermanencier" class="form" >
					<INPUT type="text" style="width:200px;" id="nompermanencier" name="nompermanencier" list="lstMembres" value="" />
					<UL class="tinyBoutons" data-formname="formaddparticipant">
						<li class="ajaxSearch add" data-url="_Calendrier_addPermanencier&type=0" data-idcible="lstPermanenciers" data-idinput="#nompermanencier" title="Ajouter un participant">Ajouter</li>
					</UL>
				</SPAN>
			</DIV>
			<DIV>
				<LABEL>
					Animateurs : 
				</LABEL>
				<SPAN id="formaddanimateur" name="formaddanimateur" class="form" >
					<INPUT type="text" style="width:200px;" id="nomanimateur" name="nomanimateur" list="lstAnimateurs" value="" />
					<UL class="tinyBoutons" data-formname="formaddparticipant">
						<li class="ajaxSearch add" data-url="_Calendrier_addPermanencier&type=1" data-idcible="lstPermanenciers" data-idinput="#nomanimateur" title="Ajouter un animateur">Ajouter</li>
					</UL>
				</SPAN>
			</DIV>
			<DIV>
				<LABEL></LABEL>
				<SPAN id="lstPermanenciers" data-pos="<?= count($randonniere->permanenciers)+1 ?>" data-max="0">
					<INPUT type="hidden" id="permanenciers" name="permanenciers" value="true" />
					<?php $randonniere->displayPermanenciers(true); ?>
				</SPAN>
			</DIV>
			<DATALIST id="lstMembres">
				<?= Membre::selectListForm('nom,prenom','id_etat NOT IN (7)','nom,prenom') ?>
			</DATALIST>
			<DATALIST id="lstAnimateurs">
				<?= Membre::selectListForm('nom,prenom','id_etat NOT IN (7) AND id IN (SELECT id_membre FROM gari_role_membre WHERE id_role = 2)','nom,prenom') ?>
			</DATALIST>
		<?php
			}
			elseif ( $randonniere->type_event == 1 )
			{
		?>
			<DIV>
				<LABEL>Nom du responsable : </LABEL>
				<SPAN>
					<?php
						$id = 0;
						if ( $randonniere->id_responsable != null ) $id = $randonniere->id_responsable->id;
						echo Membre::displayListAnimateurs($id,false,'id_responsable');
					?>
				</SPAN>
			</DIV>
		<?php
			}
		?>
		
		<input type="hidden" name="validForm" value="formAddPermanence" />
		<input type="hidden" name="date_event" value="<?= $randonniere->getAttribut('date_event')->date ?>" />
		<input type="hidden" name="id" value="<?= $randonniere->id ?>" />
			
		<ul class="Boutons" data-formname="formAddPermanence">
			<li class="submit" title="Valider le formulaire" >Valider</li>
			<li class="cancel" title="Sortir sans enregistrer" >Annuler</li>
		</ul>
		
	</FORM>
	
</DIV>	
