<?php	
	use lib\DisplayEntity;
	$lstEntities  = $Model['lstEntities'];
	$datedeb  = $Model['datedeb'];
	$datefin  = $Model['datefin'];
	$dateTime   = \DateTime::createFromFormat( 'd/m/Y' , $datefin ) ;
	$datenext = $dateTime->format('dmY');
?>
<H1>Gestion de la randonnière</H1>

<ul class="Boutons">
	<?= DisplayEntity::displayBouton('bouton','Imprimer le tableau','Edition','printPermanences','print',"datedeb=$datedeb&datefin=$datefin","Imprimer le tableau") ?>
	<?= DisplayEntity::displayBouton('retour','Page précédente') ?>
</ul>

<H2>Liste des permanences du <?= $datedeb ?> au <?= $datefin ?></H2>

<ul class="Boutons">
	<?php
	if ( isset( $Model['ISNEXT'] ) ) {
		?>
	<li class="bouton calendar" data-url="_Calendrier_listPermanences" title="Mois précédent">Mois en cours</li>
	<?php
	} else {
	?>
	<li class="bouton calendar" data-url="_Calendrier_listPermanences&date=<?= $datenext ?>" title="Mois suivant">Mois suivant</li>
	<?php
	}
	?>
</ul>

<TABLE width="100%" border="0">

    <TR class="ligneHeader">
		<TH style="width:15%;">Date</TH>
		<TH style="width:10%;">Heure début</TH>
		<TH style="width:10%;">Heure fin</TH>
		<TH style="width:32%;">Description</TH>
		<TH style="width:33%;">Permanenciers</TH>
	</TR>
	
<?php
	$bgcolor = false;
	$mois = 0;
	foreach( $lstEntities as $entity) 
	{
		$class = '';
		if ($bgcolor) $class = 'class="tabLigneBg"';
		$bgcolor = !$bgcolor;
?>

    <TR <?=$class ?> >
		<TD class="alignCenter"><?= $entity->getAttribut('date_event')->date ?></TD>
		<TD class="alignCenter"><?= $entity->getAttribut('datestart_event')->heureMin ?></TD>
		<TD class="alignCenter"><?= $entity->getAttribut('dateend_event')->heureMin ?></TD>
		<TD><?= $entity->description_event ?></TD>
		<TD>
			<UL>
				<?php
					foreach ( $entity->permanenciers as $personne ) {
						echo "<LI>".(string)$personne."</LI>";
					}
				?>
			</UL>
		</TD>
	<TR>

<?php
	}
?>
	
</TABLE>
