<?php	
	use lib\attributs\DateHeure;
	use lib\security\Security;
	use lib\DisplayEntity;
	use entities\Randonnee;
	
	$lstEntities  = $Model['lstEntities'];
	$datedebut    = ( isset($Model['datedebut']) ) ? $Model['datedebut'] : '';
	$datefin      = ( isset($Model['datefin']) ) ? $Model['datefin'] : '';
?>
<H1>Gestion des reconnaisances</H1>

<p>Bienvenue sur la page de gestion des Reconnaissances. Le tableau ci-dessous contient les reconnaissances programmées pour les mois à venir.</p>

<ul class="Boutons">
	<?= DisplayEntity::displayBouton('bouton','Imprimer le tableau','Reconnaissance','lstPrint','print',null,"Imprimer le tableau") ?>
	<?= DisplayEntity::displayBouton('retour','Page précédente') ?>
</ul>

<H2>Liste des reconnaissances programmées</H2>

<H3><?= count($lstEntities) ?> reconnaissance(s) programmée(s) !</H3>

<form class="formfiltre autosubmit" name="filtreProgramme" action="_Reconnaissance_list" method="POST" autocomplete="off">
	<h4>Filtres ...</h4>
	<label>Reconnaissances prévues entre le ... </label><input type="text" class="date" name="datedebut" placeholder="jj/mm/yyyy" value="<?= $datedebut ?>" />
	<label>et le ... </label><input type="text" class="date" name="datefin" placeholder="jj/mm/yyyy" value="<?= $datefin ?>" />
	<input type="hidden" name="validForm" value="formFiltre" />
</form>

<?php 
	$Model['onglet'] = 'reconnaissances';
	include "views/ongletsRandos.php"; 
?>

<TABLE width="100%" border="0">
    <TR class="ligneHeader">
		<TH style="width:8%;">Date reconn.</TH>
		<TH style="width:8%;">Date randonnée</TH>
		<TH style="width:28%;">Lieu prévu pour la randonnée</TH>
		<TH style="width:35%;">Parcours reconnus</TH>
		<TH style="width:12%;">Responsable</TH>
		<TH style="width:7%;">Actions</TH>
		<TH style="width:4%;">Etat</TH>
	</TR>
</TABLE>
	
<?php
	$bgcolor = false;
	$mois = 0;
	foreach( $lstEntities as $entity) 
	{
		$class = '';
		if ($bgcolor) $class = 'class="tabLigneBg"';
		$bgcolor = !$bgcolor;
		$moiscour = $entity->getAttribut('datereco')->mois;
		$anneecour = $entity->getAttribut('datereco')->annee;
		
		if ( !empty($mois) && $mois != $moiscour )
		{
		?>
			</TABLE>
		<?php
		}
		
		if ( empty($mois) || $mois != $moiscour ) 
		{
			$mois = $moiscour;
		?>
			<TABLE width="100%" border="0">
				<CAPTION>Reconnaissances pour le mois de <?= DateHeure::getLibelleMois(intval($mois)) ?> <?= $anneecour ?></CAPTION>
		<?php
		}
?>

    <TR <?=$class ?> >
		<TD style="width:8%;" class="alignCenter"><?= $entity->getAttribut('datereco')->date ?></TD>
		<TD style="width:8%;" class="alignCenter"><?= $entity->programme->getAttribut('datedepart')->date ?></TD>
		<TD style="width:28%;"><?= $entity->programme->randonnee ?></TD>
		<TD style="width:35%;"><?= $entity->getAttribut('parcours') ?></TD>
		<TD style="width:12%;"><?= $entity->responsable ?></TD>
		<TD style="width:7%;" class="alignCenter">
			<UL class="BtnsIco">
				<?= DisplayEntity::displayBouton('bouton','','Reconnaissance','display','display','id='.$entity->id,"Détail de la reconnaissance") ?>
				<?php 
					$datetime1 = new \DateTime($entity->datereco);
					$datetime2 = new \DateTime(date('Y-m-d'));
					if ( $entity->etat == 0 || ( $entity->synthese != null && $entity->synthese->remboursement == 0 ) || Security::isAdmin() || Security::isCoordinateur() ) {
						echo DisplayEntity::displayBouton('bouton','','Reconnaissance','update','edit','id='.$entity->id,"Modifier la reconnaissance",null,null,$entity) ;
						if ( $entity->synthese != null && $entity->synthese->remboursement == 0 ) {
							echo DisplayEntity::displayBouton('bouton','','Reconnaissance','frais','payer','id='.$entity->id,"Saisie des frais de la reconnaissance") ;
						}
						echo DisplayEntity::displayBouton('bouton','','Reconnaissance','delete','delete','id='.$entity->id,"Supprimer la reconnaissance") ;
					}
				?>
			</UL>
		</TD>
		<TD style="width:4%;" class="alignCenter">
			<?php 
				if ($entity->etat == 1) 
				{ 
			?>
				<IMG style="width:18px;" src="web/images/icones/100.png" />
			<?php 
				} 
				elseif ($entity->etat == 3) 
				{
			?>
				<IMG style="width:18px;" src="web/images/icones/129.png" />
			<?php 
				}
				elseif ($entity->etat == 0) 
				{
					if ( Security::isCoordinateur() || Security::isGestionnaire() || Security::isAdmin() ) { 
			?>
				<A href="_Reconnaissance_valide&id=<?= $entity->id ?>" title"Valider la reconnaissance"><IMG style="width:18px;" src="web/images/icones/115.png" /></A>
			<?php 
					} 
					else { 
			?>
				<IMG style="width:18px;" src="web/images/icones/115.png" />
			<?php 
					} 
				}
			?>
		</TD>
	<TR>

<?php
	}
?>
	
</TABLE>
