<?php
	use lib\DisplayEntity;
	use lib\security\Security;
	use entities\Programme;
	use entities\Reconnaissance;
	use entities\Membre;
	use entities\Reco_Participant;
	
	$reco = $Model['entity'];
	$action = "update";
	if ( $reco->id == null ) $action = "insert";
?>
	
<H1>Déclaration des frais de la reconnaissance de randonnée</H1>
		
<ul class="Boutons">
	<?= DisplayEntity::displayBouton('retour','Retour') ?>
</ul>

<FORM id="formReco" name="formReco" class="form" action="_Reconnaissance_frais" method="POST" autocomplete="off" enctype="multipart/form-data">

	<DIV class="table form">

		<H2><?= $reco ?></H2>

		<DIV>
			<LABEL>Véhicule(s) : </LABEL>
			<SPAN>
				<?php
					for ( $cpt = 1; $cpt <= $reco->vehicule; $cpt++) {
						$col = 'vehicule'.$cpt;
						$checked = '';
						if ( $reco->synthese->$col == 1 ) $checked = 'CHECKED';
				?>
					<DIV> <INPUT type="checkbox" name="<?= $col ?>" value="1" <?= $checked ?> /> Véhicule <?= $cpt ?> </DIV>
				<?php
					}
				?>
			</SPAN>
		</DIV>

		<?php
			if ( $reco->vehiculeFormation > 0 ) {
				$checked = '';
				if ( $reco->synthese->vehiculeFormation == 1 ) $checked = 'CHECKED';
		?>
			<DIV>
				<LABEL>Véhicule(s) de formation : </LABEL>
				<SPAN>
					<DIV> <INPUT type="checkbox" name="vehiculeFormation" value="1" <?= $checked ?> /> Véhicule de formation </DIV>
				</SPAN>
			</DIV>
		<?php
			}
		?>
		
		<H2>Validation</H2>
		
		<DIV>
			<LABEL>Frais validés : </LABEL>
			<SPAN>
				<?php
					$checked = '';
					if ( $reco->synthese->remboursement == 1 ) $checked = 'CHECKED';
				?>
				<DIV> <INPUT type="checkbox" name="remboursement" value="1" <?= $checked ?> /></DIV>
			</SPAN>
		</DIV>
			
	</DIV>

	<input type="hidden" name="validForm" value="formReco" />
	<input type="hidden" name="id" value="<?= $reco->id ?>" />
	<input type="hidden" name="id_programme" value="<?= $reco->id_programme->id ?>" />
		
	<ul class="Boutons" data-formname="formReco">
		<li class="submit">Valider</li>
		<li class="cancel">Annuler</li>
	</ul>
	
</FORM>

<DATALIST id="lstAnimateurs">
	<?= Membre::selectListForm('nom,prenom','id_etat NOT IN (7) AND id IN (SELECT id_membre FROM gari_role_membre WHERE id_role = 2)','nom,prenom') ?>
</DATALIST>
