
/*
 * Vérification des champs des formulaires
 */
function isObligatoire(obj)
{
	var ret = true;
	var formName = obj.parent().data("formname");
	$("#"+formName+" input[required]").each( function() {
		if ( $(this).val() != '' ) { 
			$(this).removeClass('ko');
			$(this).addClass('ok'); 
		}
		else { 
			$(this).removeClass('ok');
			$(this).addClass('ko'); 
			ret = false;
			alert($(this).attr('name'));
		}
	});
	return ret;
}

function isNumber(obj)
{
	if ( obj.val().trim() == '' ) {
		obj.removeClass('ko');
		obj.removeClass('ok');
	}
	else {
		obj.val( obj.val().replace(/[^0-9]/g,'') );
		var regexp = /^[0-9]+$/;
		if (regexp.test(obj.val()) ) { obj.removeClass('ko'); obj.addClass('ok'); } 
		else { obj.removeClass('ok');  obj.addClass('ko'); 
			alert(obj.attr('name'));
		}
	}
}

function isFloat(obj)
{
	if ( obj.val().trim() == '' ) {
		obj.removeClass('ko');
		obj.removeClass('ok');
	}
	else {
		obj.val( obj.val().replace(/,/g,'.') );
		obj.val( obj.val().replace(/[^0-9.]/g,'') );
		var regexp = /^[0-9]+[.,]{0,1}[0-9]*$/;
		if (regexp.test(obj.val()) ) { obj.removeClass('ko'); obj.addClass('ok'); } 
		else { obj.removeClass('ok');  obj.addClass('ko'); 
			alert(obj.attr('name'));
		}
	}
}

function isDate(obj)
{
	if ( obj.val().trim() == '' ) {
		obj.removeClass('ko');
		obj.removeClass('ok');
	}
	else {
		obj.val( obj.val().replace(/[^0-9]/g,'') );
		var regexp = /^([0-9]{2})([0-9]{2})([0-9]{4})$/;
		if (regexp.test(obj.val()) ) { 
			obj.val( obj.val().replace(regexp,'$1/$2/$3') );
			obj.removeClass('ko'); obj.addClass('ok'); 
		} 
		else { obj.removeClass('ok'); obj.addClass('ko'); 
			alert(obj.attr('name'));
		}
	}
}

function isTime(obj)
{
	if ( obj.val().trim() == '' ) {
		obj.removeClass('ko');
		obj.removeClass('ok');
	}
	else {
		obj.val( obj.val().replace(/[^0-9hH:]/g,'') );
		obj.val( obj.val().replace(/[h:]/g,'H') );
		if ( obj.val().indexOf("H") < 0 ) obj.val( obj.val()+'H' );
		while ( obj.val().indexOf("H") < 2 ) obj.val( '0'+obj.val() );
		while ( obj.val().length < 5 ) obj.val( obj.val()+'0' );
		var regexp = /^([0-9]{1,2})[H]([0-9]{0,2})$/;
		if (regexp.test(obj.val()) ) { 
			obj.val( obj.val().replace(regexp,'$1H$2') );
			obj.removeClass('ko'); obj.addClass('ok'); 
		} 
		else { obj.removeClass('ok'); obj.addClass('ko'); 
			alert(obj.attr('name'));
		}
	}
}

function isPhone(obj)
{
	if ( obj.val().trim() == '' ) {
		obj.removeClass('ko');
		obj.removeClass('ok');
	}
	else {
		obj.val( obj.val().replace(/[^0-9+]/g,'') );
		var regexp = /^([+][0-9]{2}){0,1}([0-9]{1,2})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})$/;
		if (regexp.test(obj.val()) ) { 
			obj.val( obj.val().replace(regexp,'$1 $2 $3 $4 $5 $6') );
			obj.removeClass('ko'); obj.addClass('ok'); 
		} 
		else { obj.removeClass('ok'); obj.addClass('ko'); 
			alert(obj.attr('name'));
		}
	}
}

function isMail(obj)
{
	if ( obj.val().trim() == '' ) {
		obj.removeClass('ko');
		obj.removeClass('ok');
	}
	else {
		var regexp = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9._-]+\.(fr|com|gouv|org|net)$/;
		if (regexp.test(obj.val()) ) { obj.removeClass('ko'); obj.addClass('ok'); } 
		else { obj.removeClass('ok'); obj.addClass('ko'); 
			alert(obj.attr('name'));
		}
	}
}

/*
 * Cette fonction permet de vérifier que les valeurs de 2 champs sont identiques
 * Le nom du champs est passé en paramètre
 * Le champs de vérification porte le même nom avec le postfixe "Confirm"
*/
function isConfirm(objConfirm)
{
	var obj = $("input[name='"+ objConfirm.attr('name').replace("Confirm","") +"']");
	if ( objConfirm.val() == obj.val() ) { 
		obj.removeClass('ko');
		objConfirm.removeClass('ko');
		obj.addClass('ok'); 
		objConfirm.addClass('ok'); 
	} 
	else { 
		obj.removeClass('ok');
		objConfirm.removeClass('ok');
		obj.addClass('ko'); 
		objConfirm.addClass('ko'); 
	}
}
 
/*
 * Foncton d'affichage des messages d'alerte
 * Si le message d'alerte n'est pas vide 
 */
/*
 function displayAlert() {
	if ( $('#ALERTMESSAGE').html().trim() != '' ) {
		var titre = 'Alert !';
		if ( $('#ALERTMESSAGE').data('titre').trim() != '' ) {
			titre = $('#ALERTMESSAGE').data('titre'); 
		}
		$('#ALERTMESSAGE').prepend("<H3>"+titre+"<H3>");
		$('#ALERTMESSAGE').slideDown('slow');
		$('#ALERTMESSAGE').delay(3000).slideUp('slow');
	}
 }
*/
 function displayAlert() {
	if ( $('#ALERTMESSAGE').html().trim() != '' ) {
		var titre = 'Alert !';
		if ( $('#ALERTMESSAGE').data('titre').trim() != '' ) {
			titre = $('#ALERTMESSAGE').data('titre'); 
		}
		$('#ALERTMESSAGE').dialog({ 'modal': true, 'width': 400, 'title': titre });
		$('#ALERTMESSAGE').show();
	}
 }
 
// *******************
// * Fonction SLIDER *
// *******************
function initSwitchElements($objId,temporisation) {
	slidshow = setInterval(	
		function(){  
			moveleft($objId);
		}, 
		temporisation);  // Intervale entre 2 r?tition de la fonction
}

function moveleft($objId)
{
	var largeur = $($objId).width();
	temposisation = 1500;
	$($objId+" UL li:first-child").animate({marginLeft:-largeur},temposisation,function(){  
		$(this).css("margin-left",0).appendTo($objId+" UL"); 
	});  
}

/*
 * ********************************
 * INITIALISATION DES DATES PICKER
 * ********************************
 */
$.datepicker.setDefaults({
	showOn: "both",
	changeMonth: true,
	changeYear: true,
	buttonImageOnly: true,
	buttonImage: "web/images/calandar.png",
	buttonText: "Calendrier",
	autoSize: true,
	dateFormat: "dd/mm/yy",
	dayNamesMin: [ "Di", "Lu", "Ma", "Me", "Je", "Ve", "Sa" ],
	monthNames: [ "Janvier", "Février", "Mars", "Avril", "Mai", "Juin", "Juillet", "Août", "Septembre", "Octobre", "Novembre", "Décembre" ],				
});

/*
 * Action sur click d'une Option d'un Menu.
 */
function selectIndex(obj)
{
	$('.selectedOption').removeClass("selectedOption");
	obj.addClass("selectedOption");
}


/*
 * Fonction de gestion des liste de choix multiples.
 */
function addSelect(debut,fin) {
	$(debut).find(":selected").each(function(){
		$(fin).append('<option value="'+$(this).attr('value')+'">'+$(this).text()+'</option>');
		$(this).remove();
	});
}

function dropSelect(debut,fin) {
	$(fin).find(":selected").each(function(){
		$(debut).append('<option value="'+$(this).attr('value')+'">'+$(this).text()+'</option>');
		$(this).remove();
	});
}

function validerSelect() {
	$('.listeMultiple').find("option").each(function(){
		$(this).prop('selected', true);
	});
	return false;
}

/*
 * Gestion du bandea slideshow automatique
 */
function switchImages()
{
	$objVisible = $('.bandeauSwitchImages>li:visible');
	var nbelmts = $('.bandeauSwitchImages>li').length;
	var cpt = nbelmts;
	if ($objVisible.length == 1) 
	{
		cpt = $('.bandeauSwitchImages>li').index($objVisible)
		cpt++;
	}
	$('.bandeauSwitchImages>li:nth-child('+cpt+')').fadeOut(2000);
	cpt = cpt % nbelmts;
	cpt++;
	$('.bandeauSwitchImages>li:nth-child('+cpt+')').fadeIn(2000);
}

/*
 * Initialisation de sparamètres Google Map
 */
function initGoogleMap(blocMap,address) {
	var geocoder = new google.maps.Geocoder();
	geocoder.geocode( { 'address': address}, function(results, status) {
		if (status == google.maps.GeocoderStatus.OK) {
			var options = {
				center: results[0].geometry.location,
				zoom: 10,									// Zoom (entre 0 et 20)
				keyboardShortcuts: false,					// Active / Désactive les racourcis clavier
				scrollwheel: false,							// Active / Désactive le zomm avec la roue de la sourie
				mapTypeControl: false,						// Affiche / Cache les boutons de type de carte
				panControl: false,							// Affiche / Cache les boutons du panneau
				zoomControl: false,							// Affiche / Cache les boutons de zomm
				streetViewControl: false,					// Affiche / Cache les boutons d'appercu des rues
				mapTypeId: google.maps.MapTypeId.ROADMAP,	// Type de carte
			};
			var carte = new google.maps.Map(document.getElementById(blocMap), options);
			
			var cercle = new google.maps.Circle({
				center: results[0].geometry.location,
				radius: 10000,
				strokeColor: "#FF0000",
				strokeOpacity: 0.5,
				strokeWeight: 2,
				fillColor: "#FF0000",
				fillOpacity: 0.2,
				map: carte
			});
		}
		else {
			alert('Adresse incorecte');
		}
	});
}

function autoSubmit() {
	$(".autosubmit").each(function() {
		var form = $(this);
		$(this).find("SELECT").change(
			function() {
				form.submit();
			}
		);
		$(this).find("INPUT").change(
			function() {
				form.submit();
			}
		);
	});
}

function selectChange(obj) {
	var url = obj.data("url");
	var titre = obj.data("titre");
	var idc = obj.data("idcible");
	var pos = $(idc).data("pos");
	var id = obj.find("option:selected").val();
	requestAjax(url+"&idEntity="+id+"&pos="+pos+"&idc="+idc,"#popup",popupData,null,titre);
}

function ajaxSearch(obj) {
	var url = obj.data("url");
	var titre = obj.data("titre");
	var idc = obj.data("idcible");
	var pos = $(idc).data("pos");
	var id = obj.val();
	requestAjax(url+"&idEntity="+id+"&pos="+pos,"#"+idc,appendData,null,null);
	popupClose("#popup");
}

function initBoutonsForm() {
	var btnGrpObj = $(".Boutons,.BtnTitle,.FormBoutons,.BtnsIco,.tinyBoutons");
	btnGrpObj.find(".submit").each(
		function(){
			$(this).unbind( "click" );
			$(this).click(function(){ 
				validerSelect();
				if (isObligatoire($(this)))
				{
					var formName = $(this).parent().data("formname");
					$('#'+formName).submit();
				}
			});
		}
	);
	btnGrpObj.find(".cancel").each(
		function(){
			$(this).unbind( "click" );
			$(this).click( function(){
				document.location.href="_Default_prev"; 
			});
		}
	);
	btnGrpObj.find(".retour").each(
		function(){
			$(this).unbind( "click" );
			$(this).click( function(){
				document.location.href="_Default_prev"; 
			});
		}
	);
	btnGrpObj.find(".close").each(
		function(){
			$(this).unbind( "click" );
			$(this).click( function(){
				var popupid = $(this).data("popupid");
				$(popupid).dialog( "destroy" );
				$(popupid).hide();
				$(popupid).empty();
			});
		}
	);
	btnGrpObj.find(".switchEdit").each(
		function(){
			$(this).unbind( "click" );
			$(this).click( function(){
				var idbloc = $(this).data("idbloc");
				$(idbloc).find(".displayElmt").toggle();
				$(idbloc).find(".editElmt").toggle();
			});
		}
	);
	btnGrpObj.find(".drop").each(
		function(){
			$(this).unbind( "click" );
			$(this).click( function(){
				var pos = $(this).data("pos");
				dropForm(pos);
			});
		}
	);
	btnGrpObj.find(".reset").each(
		function(){
			$(this).unbind( "click" );
			$(this).click( function(){
				var pos = $(this).data("pos");
				$("#"+pos).find('.displayElmt').show();
				$("#"+pos).find('.editElmt').hide();
				$("#"+pos).find('.editElmt').find('SELECT>OPTION:first-child').prop( "selected", true );
				$("#"+pos).find('.editElmt').find('INPUT[type=text]').val( '' );
				$("#"+pos).find('.editElmt').find('TEXTAREA').val( '' );
			});
		}
	);
	btnGrpObj.find(".up").each(
		function(){
			$(this).unbind( "click" );
			$(this).click( function(){
				var pos = $(this).data("pos");
				upForm(pos);
			});
		}
	);
	btnGrpObj.find(".bouton").each(
		function(){
			$(this).unbind( "click" );
			$(this).click( function(){
				if ( ! $(this).hasClass('grise') ) window.location.href = $(this).data("url");
				else alert('Action non permise.');
			});
		}
	);
	btnGrpObj.find(".ajaxAdd").each(
		function(){
			$(this).unbind( "click" );
			$(this).click( function(){
				var url = $(this).data("url");
				var idc = $(this).data("idcible");
				var pos = $("#"+idc).data("pos");
				var max = $("#"+idc).data("max");
				if ( typeof(pos)  != "undefined" ) {
					url = url + "&pos="+pos;
					$("#"+idc).data("pos",pos+1);
				}
				if ( typeof(max)  != "undefined" ) {
					url = url + "&max="+max;
					if (max > 0) $("#"+idc).data("max",max-1);
				}	
				requestAjax(url,"#"+idc,appendData,null,null);
			});
		}
	);
	btnGrpObj.find(".ajaxSearch").each(
		function(){
			$(this).unbind( "click" );
			$(this).click( function(){
				var url = $(this).data("url");
				var idc = $(this).data("idcible");
				var idi = $(this).data("idinput");
				var valEntity = $(idi).val();
				var max = $("#"+idc).data("max");
				var pos = $("#"+idc).data("pos");
				$("#"+idc).data("pos",pos+1);
				if (max > 0) $("#"+idc).data("max",max-1);
				requestAjax(url+"&valEntity="+valEntity+"&pos="+pos+"&max="+max,"#"+idc,appendData,null,null);
				$(idi).val('');
			});
		}
	);
	btnGrpObj.find(".ajaxOpen").each(
		function(){
			$(this).unbind( "click" );
			$(this).click( function(){
				var url = $(this).data("url");
				var idc = $(this).data("idcible");
				var max = $("#"+idc).data("max");
				var pos = $("#"+idc).data("pos");
				var titre = $(this).data("titre");
				if ( typeof(idc)  != "undefined" ) {
					url = url + "&idc="+idc;
				}
				if ( typeof(pos)  != "undefined" ) {
					url = url + "&pos="+pos;
					$("#"+idc).data("pos",pos+1);
				}
				if ( typeof(max)  != "undefined" ) {
					url = url + "&max="+max;
					if (max > 0) $("#"+idc).data("max",max-1);
				}	
				requestAjax(url,"#popup",popupData,null,titre);
			});
		}
	);
	
	btnGrpObj.find(".ajaxSubmit").each(
		function(){
			$(this).unbind( "click" );
			$(this).click( function(){
				validerSelect();
				if (isObligatoire($(this)))
				{
					var formName = $(this).parent().data("formname");
					var url = $(this).data("url");
					var idc = $(this).data("idcible");
					requestAjax(url,"#"+idc,replaceData,"#"+formName,null);
					popupClose("#popup");
				}
			});
		}
	);
	
	btnGrpObj.find(".ajaxSubmitAppend").each(
		function(){
			$(this).unbind( "click" );
			$(this).click( function(){
				validerSelect();
				if (isObligatoire($(this)))
				{
					var formName = $(this).parent().data("formname");
					var url = $(this).data("url");
					var idc = $(this).data("idcible");
					requestAjax(url,"#"+idc,appendData,"#"+formName,null);
					popupClose("#popup");
				}
			});
		}
	);
	
	$("#participants").find(".ventile").each(
		function(){
			$(this).unbind( "change" );
			$(this).change( function(){
				var url = $(this).data("url")+'&etat='+$(this).prop('checked');
				requestAjax(url,null,noDisplayData,null,null);
			});
		}
	);
	
	$("FORM").keypress( function(e) {
		if ( e.keyCode == 13 ) {
			$(this).find(".ajaxSubmit").each(function(){
				$(this).click();
			});
           $(this).find(".submit").each(function(){
				$(this).click();
			});
		}
	});
	
}

function changeAttente(obj) 
{
	var idbloc = obj.find("SELECT").data('idcible');
	var max = obj.parent().data("max");
	if ( obj.find('OPTION:SELECTED').val() == 1 ) {
		$("#"+idbloc).addClass('attente');
		obj.parent().data("max",max+1);
	}
	else {
		$("#"+idbloc).removeClass('attente');
		obj.parent().data("max",max-1);
	}
}

function changeDisable(className)
{
	if ( $(className).attr('DISABLED') ) $(className).removeAttr('DISABLED');
	else $(className).attr('DISABLED','DISABLED');
}

/*
 * SPRESSION D'un ELEMENT HTML
 */
 
function dropForm(obj)
{
	var max = $("#insert"+obj).parent().data("max");
	if ( $("#insert"+obj).find('OPTION:SELECTED').val() == 0 ) {
		$("#insert"+obj).parent().data("max",max+1);
	}
	$("#insert"+obj).remove();
	$("#"+obj).remove();
}

/*
 * PASSER un ELEMENT HTML DEVANT
 */
 
function upForm(obj)
{
	var bloc = $("#insert"+obj);
	var blocParent = bloc.parent();
	var position1 = bloc.find('.position').val();
	var position2 = blocParent.find('.celluleTab:first-child').find('.position').val();
	$("#insert"+obj).parent().find('.celluleTab:first-child').find('.position').val(position1);
	$("#insert"+obj).find('.position').val(position2);
//alert(position1+" ".position2);
	bloc.prependTo(blocParent);
}

/*
 * INITIALISATION DE LA GESTION DES CHAMPS DE FORMULAIRES
 */
 
function initForm() 
{
	// Lancement des vérifiaction des champs de formulaires.
	$("input.email,input.tel,input.number,input.float,input.date,input.time,input[name$='Confirm']").unbind( "change" );
	$( "input.email" ).change(function(){ isMail($(this)); });
	$( "input.tel" ).change(function(){ isPhone($(this)); });
	$( "input.number" ).change(function(){ isNumber($(this)); });
	$( "input.float" ).change(function(){ isFloat($(this)); });
	$( "input.date" ).change(function(){ isDate($(this)); });
	$( "input.time" ).change(function(){ isTime($(this)); });
	$( "input[name$='Confirm']" ).change(function(){ isConfirm($(this)); });
	$( "input[type=text],input[type=password]" ).unbind( "focus" );
	$( "input[type=text],input[type=password]" ).focus(function(){$(this).select();});
	$( "textarea" ).unbind( "focus" );
	$( "textarea" ).focus(function(){ $(this).select(); });
}
	
/*
 * *********************************
 * INIT APRES CHARGEMENT DE LA PAGE
 * *********************************
 */
$( document ).ready(function() {
	// Affichage du messagege d'alerte
	displayAlert();
	
	// Ajout des évènement sur les menus d'options
	$('.menuOptions').find('A').each(function(){$(this).click(function(){selectIndex($(this));});});

	// Lancement du SlideShow automatique
	$('.bandeauSwitchImages>li:first').fadeIn(2000);
	setInterval(switchImages,5000);

	// Utilisation des datepicker.
	$( ".datepicker" ).datepicker();		// UTILISATION DES DATEPICKER POUR LES OBJETS DE CLASSE "datepicker"
	
	// Inititlisa la gestion des champs des formulaires.
	initForm();

	/*
	 * ***************************
	 * INITIALISATION DE TINIMCE
	 * Textarea avec ID = article
	 * ***************************
	 */
	tinyMCE.init({
		mode     : "exact",
		elements : "note,anoter,commentaire,remarques,article,message,adresseStr,information",
		theme    : "simple"
	});
	
	initBoutonsForm();
	autoSubmit();

	//initGoogleMap('googleMap','FRANCE, VAR, LA CRAU');	
});
