<?php
namespace jpi\services;
require_once __DIR__.'/../autoloader.php';

use jpi\lib\Formatage as MyFormatage;
use jpi\lib\Transaction as MyTransaction;

if ( isset($_GET['user'])) {
	$uid = $_GET['user'];
	$query = sprintf("SELECT L.udl, L.titre, C.libelle as categorie, max(F.version) as version 
			FROM jpi_ligne L, jpi_fichier F, jpi_categorie C, jpi_user U 
			WHERE F.id_ligne = L.id AND L.id_categorie = C.id AND L.id_user = U.id AND U.uid = %s
			GROUP BY L.udl", 
			MyFormatage::GetSQLValueString($uid, "text")
		);
	$myTransaction = new MyTransaction();
	$myTransaction->setQuery($query);
	$myTransaction->execute();
	
	if ($myTransaction->asResult())
	{
		// Création des headers, pour indiquer au navigateur qu'il s'agit d'un fichier à télécharger
		header('Content-Transfer-Encoding: text/plain'); 
		header('Content-Type: application/force-download');
		header('Content-Disposition: attachment; filename="'.$uid.'-files.json"'); //Nom du fichier
		
		//Envoi dans le flux
		while ($row = $myTransaction->getNextRow())
		{
			echo json_encode($row)."\n";
		}
	}
}
